/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.samples.plain.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.naming.Name;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.samples.plain.dao.PersonDao;
import org.springframework.ldap.samples.plain.domain.Person;
import org.springframework.ldap.samples.utils.HtmlRowLdapTreeVisitor;
import org.springframework.ldap.samples.utils.LdapTree;
import org.springframework.ldap.samples.utils.LdapTreeBuilder;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DefaultController {
    @Autowired
    private LdapTreeBuilder ldapTreeBuilder;
    @Autowired
    private PersonDao personDao;

    @RequestMapping(value={"/welcome.do"})
    public void welcomeHandler() {
    }

    @RequestMapping(value={"/showTree.do"})
    public ModelAndView showTree() {
        LdapTree ldapTree = this.ldapTreeBuilder.getLdapTree(LdapUtils.emptyLdapName());
        PersonLinkHtmlRowLdapTreeVisitor visitor = new PersonLinkHtmlRowLdapTreeVisitor();
        ldapTree.traverse(visitor);
        return new ModelAndView("showTree", "rows", visitor.getRows());
    }

    @RequestMapping(value={"/addPerson.do"})
    public String addPerson() {
        Person person = this.getPerson();
        this.personDao.create(person);
        return "redirect:/showTree.do";
    }

    @RequestMapping(value={"/updatePhoneNumber.do"})
    public String updatePhoneNumber() {
        Person person = this.personDao.findByPrimaryKey("Sweden", "company1", "John Doe");
        person.setPhone(StringUtils.join((Object[])new String[]{person.getPhone(), "0"}));
        this.personDao.update(person);
        return "redirect:/showTree.do";
    }

    @RequestMapping(value={"/removePerson.do"})
    public String removePerson() {
        Person person = this.getPerson();
        this.personDao.delete(person);
        return "redirect:/showTree.do";
    }

    @RequestMapping(value={"/showPerson.do"})
    public ModelMap showPerson(String country, String company, String fullName) {
        Person person = this.personDao.findByPrimaryKey(country, company, fullName);
        return new ModelMap("person", (Object)person);
    }

    private Person getPerson() {
        Person person = new Person();
        person.setFullName("John Doe");
        person.setLastName("Doe");
        person.setCompany("company1");
        person.setCountry("Sweden");
        person.setDescription("Test user");
        return person;
    }

    private static final class PersonLinkHtmlRowLdapTreeVisitor
    extends HtmlRowLdapTreeVisitor {
        private PersonLinkHtmlRowLdapTreeVisitor() {
        }

        @Override
        protected String getLinkForNode(DirContextOperations node) {
            String[] objectClassValues = node.getStringAttributes("objectClass");
            if (this.containsValue(objectClassValues, "person")) {
                Name dn = node.getDn();
                String country = this.encodeValue(LdapUtils.getStringValue((Name)dn, (String)"c"));
                String company = this.encodeValue(LdapUtils.getStringValue((Name)dn, (String)"ou"));
                String fullName = this.encodeValue(LdapUtils.getStringValue((Name)dn, (String)"cn"));
                return "showPerson.do?country=" + country + "&company=" + company + "&fullName=" + fullName;
            }
            return super.getLinkForNode(node);
        }

        private String encodeValue(String value) {
            try {
                return URLEncoder.encode(value, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unexpected encoding exception", e);
            }
        }

        private boolean containsValue(String[] values, String value) {
            for (String oneValue : values) {
                if (!StringUtils.equals((String)oneValue, (String)value)) continue;
                return true;
            }
            return false;
        }
    }
}

