/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.samples.utils;

import java.util.LinkedList;
import java.util.List;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.samples.utils.LdapTreeVisitor;

public class HtmlRowLdapTreeVisitor
implements LdapTreeVisitor {
    private List<String> rows = new LinkedList<String>();

    @Override
    public void visit(DirContextOperations node, int currentDepth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < currentDepth; ++i) {
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        sb.append("<a href='").append(this.getLinkForNode(node)).append("'>").append(node.getDn()).append("</a>").append("<br>\n");
        this.rows.add(sb.toString());
    }

    protected String getLinkForNode(DirContextOperations node) {
        return "#";
    }

    public List<String> getRows() {
        return this.rows;
    }
}

