/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.samples.utils;

import java.util.LinkedList;
import java.util.List;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.samples.utils.LdapTreeVisitor;

public class LdapTree {
    private final DirContextOperations node;
    private List<LdapTree> subContexts = new LinkedList<LdapTree>();

    public LdapTree(DirContextOperations node) {
        this.node = node;
    }

    public DirContextOperations getNode() {
        return this.node;
    }

    public List<LdapTree> getSubContexts() {
        return this.subContexts;
    }

    public void setSubContexts(List<LdapTree> subContexts) {
        this.subContexts = subContexts;
    }

    public void addSubTree(LdapTree ldapTree) {
        this.subContexts.add(ldapTree);
    }

    public void traverse(LdapTreeVisitor visitor) {
        this.traverse(visitor, 0);
    }

    private void traverse(LdapTreeVisitor visitor, int currentDepth) {
        visitor.visit(this.node, currentDepth);
        for (LdapTree subContext : this.subContexts) {
            subContext.traverse(visitor, currentDepth + 1);
        }
    }
}

