/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.samples.utils;

import javax.naming.Name;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.samples.utils.LdapTree;
import org.springframework.ldap.support.LdapUtils;

public class LdapTreeBuilder {
    private LdapTemplate ldapTemplate;

    public LdapTreeBuilder(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public LdapTree getLdapTree(Name root) {
        DirContextOperations context = this.ldapTemplate.lookupContext(root);
        return this.getLdapTree(context);
    }

    private LdapTree getLdapTree(final DirContextOperations rootContext) {
        final LdapTree ldapTree = new LdapTree(rootContext);
        this.ldapTemplate.listBindings(rootContext.getDn(), (ContextMapper)new AbstractContextMapper<Object>(){

            protected Object doMapFromContext(DirContextOperations ctx) {
                Name dn = ctx.getDn();
                dn = LdapUtils.prepend((Name)dn, (Name)rootContext.getDn());
                ldapTree.addSubTree(LdapTreeBuilder.this.getLdapTree(LdapTreeBuilder.this.ldapTemplate.lookupContext(dn)));
                return null;
            }
        });
        return ldapTree;
    }
}

