/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.samples.plain.dao;

import java.util.List;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.samples.plain.dao.PersonDao;
import org.springframework.ldap.samples.plain.domain.Person;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.ldap.support.LdapUtils;

public class PersonDaoImpl
implements PersonDao {
    private LdapTemplate ldapTemplate;
    private static final ContextMapper<Person> PERSON_CONTEXT_MAPPER = new AbstractContextMapper<Person>(){

        public Person doMapFromContext(DirContextOperations context) {
            Person person = new Person();
            LdapName dn = LdapUtils.newLdapName((Name)context.getDn());
            person.setCountry(LdapUtils.getStringValue((Name)dn, (int)0));
            person.setCompany(LdapUtils.getStringValue((Name)dn, (int)1));
            person.setFullName(context.getStringAttribute("cn"));
            person.setLastName(context.getStringAttribute("sn"));
            person.setDescription(context.getStringAttribute("description"));
            person.setPhone(context.getStringAttribute("telephoneNumber"));
            return person;
        }
    };

    @Override
    public void create(Person person) {
        LdapName dn = this.buildDn(person);
        DirContextAdapter context = new DirContextAdapter((Name)dn);
        this.mapToContext(person, context);
        this.ldapTemplate.bind((Name)dn, (Object)context, null);
    }

    @Override
    public void update(Person person) {
        LdapName dn = this.buildDn(person);
        DirContextAdapter context = (DirContextAdapter)this.ldapTemplate.lookup((Name)dn);
        this.mapToContext(person, context);
        this.ldapTemplate.modifyAttributes((Name)dn, context.getModificationItems());
    }

    @Override
    public void delete(Person person) {
        this.ldapTemplate.unbind((Name)this.buildDn(person));
    }

    @Override
    public List<String> getAllPersonNames() {
        return this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().attributes(new String[]{"cn"}).where("objectclass").is("person"), (AttributesMapper)new AttributesMapper<String>(){

            public String mapFromAttributes(Attributes attrs) throws NamingException {
                return attrs.get("cn").get().toString();
            }
        });
    }

    @Override
    public List<Person> findAll() {
        return this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person"), PERSON_CONTEXT_MAPPER);
    }

    @Override
    public Person findByPrimaryKey(String country, String company, String fullname) {
        LdapName dn = this.buildDn(country, company, fullname);
        return (Person)this.ldapTemplate.lookup((Name)dn, PERSON_CONTEXT_MAPPER);
    }

    private LdapName buildDn(Person person) {
        return this.buildDn(person.getCountry(), person.getCompany(), person.getFullName());
    }

    private LdapName buildDn(String country, String company, String fullname) {
        return LdapNameBuilder.newInstance().add("c", (Object)country).add("ou", (Object)company).add("cn", (Object)fullname).build();
    }

    private void mapToContext(Person person, DirContextAdapter context) {
        context.setAttributeValues("objectclass", (Object[])new String[]{"top", "person"});
        context.setAttributeValue("cn", (Object)person.getFullName());
        context.setAttributeValue("sn", (Object)person.getLastName());
        context.setAttributeValue("description", (Object)person.getDescription());
        context.setAttributeValue("telephoneNumber", (Object)person.getPhone());
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }
}

