/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={RabbitTemplate.class, ObjectMapper.class})
@ConditionalOnProperty(name={"spring.modulith.events.rabbitmq.enable-json"}, havingValue="true", matchIfMissing=true)
class RabbitJacksonConfiguration {
    RabbitJacksonConfiguration() {
    }

    @Bean
    @ConditionalOnBean(value={ObjectMapper.class})
    RabbitTemplateCustomizer rabbitTemplateCustomizer(ObjectMapper mapper) {
        return template -> template.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter(mapper));
    }
}

