/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.neo4j;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Record;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.lang.Nullable;
import org.springframework.modulith.events.core.EventPublicationRepository;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.core.PublicationTargetIdentifier;
import org.springframework.modulith.events.core.TargetEventPublication;
import org.springframework.modulith.events.neo4j.Neo4jEventPublication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;

@Transactional
class Neo4jEventPublicationRepository
implements EventPublicationRepository {
    private static final String ID = "identifier";
    private static final String EVENT_SERIALIZED = "eventSerialized";
    private static final String EVENT_HASH = "eventHash";
    private static final String EVENT_TYPE = "eventType";
    private static final String LISTENER_ID = "listenerId";
    private static final String PUBLICATION_DATE = "publicationDate";
    private static final String COMPLETION_DATE = "completionDate";
    private static final org.neo4j.cypherdsl.core.Node EVENT_PUBLICATION_NODE = Cypher.node((String)"Neo4jEventPublication", (String[])new String[0]).named("neo4jEventPublication");
    private static final Statement INCOMPLETE_BY_EVENT_AND_TARGET_IDENTIFIER_STATEMENT = ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("eventHash").eq((Expression)Cypher.parameter((String)"eventHash")))).and(EVENT_PUBLICATION_NODE.property("listenerId").eq((Expression)Cypher.parameter((String)"listenerId")))).and(EVENT_PUBLICATION_NODE.property("completionDate").isNull())).returning(new Named[]{EVENT_PUBLICATION_NODE}).build();
    private static final Statement DELETE_BY_ID_STATEMENT = ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("identifier").in((Expression)Cypher.parameter((String)"identifier")))).delete(new Named[]{EVENT_PUBLICATION_NODE}).build();
    private static final Statement DELETE_COMPLETED_STATEMENT = ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("completionDate").isNotNull())).delete(new Named[]{EVENT_PUBLICATION_NODE}).build();
    private static final Statement DELETE_COMPLETED_BEFORE_STATEMENT = ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("publicationDate").lt((Expression)Cypher.parameter((String)"publicationDate")))).and(EVENT_PUBLICATION_NODE.property("completionDate").isNotNull())).delete(new Named[]{EVENT_PUBLICATION_NODE}).build();
    private static final Statement INCOMPLETE_PUBLISHED_BEFORE_STATEMENT = ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("publicationDate").lt((Expression)Cypher.parameter((String)"publicationDate")))).and(EVENT_PUBLICATION_NODE.property("completionDate").isNull())).returning(new Named[]{EVENT_PUBLICATION_NODE}).orderBy((Expression)EVENT_PUBLICATION_NODE.property("publicationDate")).build();
    private static final Statement CREATE_STATEMENT = Cypher.create((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).set(new Expression[]{EVENT_PUBLICATION_NODE.property("identifier").to((Expression)Cypher.parameter((String)"identifier"))}).set(new Expression[]{EVENT_PUBLICATION_NODE.property("eventSerialized").to((Expression)Cypher.parameter((String)"eventSerialized"))}).set(new Expression[]{EVENT_PUBLICATION_NODE.property("eventHash").to((Expression)Cypher.parameter((String)"eventHash"))}).set(new Expression[]{EVENT_PUBLICATION_NODE.property("eventType").to((Expression)Cypher.parameter((String)"eventType"))}).set(new Expression[]{EVENT_PUBLICATION_NODE.property("listenerId").to((Expression)Cypher.parameter((String)"listenerId"))}).set(new Expression[]{EVENT_PUBLICATION_NODE.property("publicationDate").to((Expression)Cypher.parameter((String)"publicationDate"))}).build();
    private static final Statement COMPLETE_STATEMENT = ((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("eventHash").eq((Expression)Cypher.parameter((String)"eventHash")))).and(EVENT_PUBLICATION_NODE.property("listenerId").eq((Expression)Cypher.parameter((String)"listenerId")))).and(EVENT_PUBLICATION_NODE.property("completionDate").isNull())).set(new Expression[]{EVENT_PUBLICATION_NODE.property("completionDate").to((Expression)Cypher.parameter((String)"completionDate"))}).build();
    private static final ResultStatement INCOMPLETE_STATEMENT = (ResultStatement)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("completionDate").isNull())).returning(new Named[]{EVENT_PUBLICATION_NODE}).orderBy((Expression)EVENT_PUBLICATION_NODE.property("publicationDate")).build();
    private static final ResultStatement ALL_COMPLETED_STATEMENT = (ResultStatement)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{EVENT_PUBLICATION_NODE}).where(EVENT_PUBLICATION_NODE.property("completionDate").isNotNull())).returning(new Named[]{EVENT_PUBLICATION_NODE}).orderBy((Expression)EVENT_PUBLICATION_NODE.property("publicationDate")).build();
    private final Neo4jClient neo4jClient;
    private final Renderer renderer;
    private final EventSerializer eventSerializer;

    Neo4jEventPublicationRepository(Neo4jClient neo4jClient, Configuration cypherDslConfiguration, EventSerializer eventSerializer) {
        Assert.notNull((Object)neo4jClient, (String)"Neo4jClient must not be null!");
        Assert.notNull((Object)cypherDslConfiguration, (String)"CypherDSL configuration must not be null!");
        Assert.notNull((Object)eventSerializer, (String)"EventSerializer must not be null!");
        this.neo4jClient = neo4jClient;
        this.renderer = Renderer.getRenderer((Configuration)cypherDslConfiguration);
        this.eventSerializer = eventSerializer;
    }

    @Transactional
    public TargetEventPublication create(TargetEventPublication publication) {
        UUID identifier = publication.getIdentifier();
        Instant publicationDate = publication.getPublicationDate();
        String listenerId = publication.getTargetIdentifier().getValue();
        Object event = publication.getEvent();
        String eventType = event.getClass().getName();
        String eventSerialized = this.eventSerializer.serialize(event).toString();
        String eventHash = DigestUtils.md5DigestAsHex((byte[])eventSerialized.getBytes());
        ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(CREATE_STATEMENT)).bindAll(Map.of(ID, Values.value((String)identifier.toString()), EVENT_SERIALIZED, eventSerialized, EVENT_HASH, eventHash, EVENT_TYPE, eventType, LISTENER_ID, listenerId, PUBLICATION_DATE, Values.value((OffsetDateTime)publicationDate.atOffset(ZoneOffset.UTC))))).run();
        return publication;
    }

    @Transactional
    public void markCompleted(Object event, PublicationTargetIdentifier identifier, Instant completionDate) {
        String eventHash = DigestUtils.md5DigestAsHex((byte[])this.eventSerializer.serialize(event).toString().getBytes());
        ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(COMPLETE_STATEMENT)).bind((Object)eventHash).to(EVENT_HASH)).bind((Object)identifier.getValue()).to(LISTENER_ID)).bind((Object)Values.value((OffsetDateTime)completionDate.atOffset(ZoneOffset.UTC))).to(COMPLETION_DATE)).run();
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublications() {
        return List.copyOf(this.neo4jClient.query(this.renderer.render((Statement)INCOMPLETE_STATEMENT)).fetchAs(TargetEventPublication.class).mappedBy(this::mapRecordToPublication).all());
    }

    @Transactional(readOnly=true)
    public List<TargetEventPublication> findIncompletePublicationsPublishedBefore(Instant instant) {
        return List.copyOf(((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(INCOMPLETE_PUBLISHED_BEFORE_STATEMENT)).bind((Object)Values.value((OffsetDateTime)instant.atOffset(ZoneOffset.UTC))).to(PUBLICATION_DATE)).fetchAs(TargetEventPublication.class).mappedBy(this::mapRecordToPublication).all());
    }

    @Transactional(readOnly=true)
    public Optional<TargetEventPublication> findIncompletePublicationsByEventAndTargetIdentifier(Object event, PublicationTargetIdentifier targetIdentifier) {
        String eventHash = DigestUtils.md5DigestAsHex((byte[])((String)this.eventSerializer.serialize(event)).getBytes());
        String listenerId = targetIdentifier.getValue();
        return ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(INCOMPLETE_BY_EVENT_AND_TARGET_IDENTIFIER_STATEMENT)).bindAll(Map.of(EVENT_HASH, eventHash, LISTENER_ID, listenerId))).fetchAs(TargetEventPublication.class).mappedBy(this::mapRecordToPublication).one();
    }

    public List<TargetEventPublication> findCompletedPublications() {
        return new ArrayList<TargetEventPublication>(this.neo4jClient.query(this.renderer.render((Statement)ALL_COMPLETED_STATEMENT)).fetchAs(TargetEventPublication.class).mappedBy(this::mapRecordToPublication).all());
    }

    @Transactional
    public void deletePublications(List<UUID> identifiers) {
        ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(DELETE_BY_ID_STATEMENT)).bind(identifiers.stream().map(UUID::toString).toList()).to(ID)).run();
    }

    @Transactional
    public void deleteCompletedPublications() {
        this.neo4jClient.query(this.renderer.render(DELETE_COMPLETED_STATEMENT)).run();
    }

    @Transactional
    public void deleteCompletedPublicationsBefore(Instant instant) {
        ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(DELETE_COMPLETED_BEFORE_STATEMENT)).bind((Object)Values.value((OffsetDateTime)instant.atOffset(ZoneOffset.UTC))).to(PUBLICATION_DATE)).run();
    }

    private Neo4jEventPublicationAdapter mapRecordToPublication(TypeSystem typeSystem, Record record) {
        Node publicationNode = record.get(EVENT_PUBLICATION_NODE.getRequiredSymbolicName().getValue()).asNode();
        UUID identifier = UUID.fromString(publicationNode.get(ID).asString());
        Instant publicationDate = publicationNode.get(PUBLICATION_DATE).asZonedDateTime().toInstant();
        String listenerId = publicationNode.get(LISTENER_ID).asString();
        String eventSerialized = publicationNode.get(EVENT_SERIALIZED).asString();
        String eventHash = publicationNode.get(EVENT_HASH).asString();
        String eventType = publicationNode.get(EVENT_TYPE).asString();
        try {
            Object event = this.eventSerializer.deserialize((Object)eventSerialized, Class.forName(eventType));
            Neo4jEventPublication publication = new Neo4jEventPublication(identifier, publicationDate, listenerId, event, eventHash);
            return new Neo4jEventPublicationAdapter(publication);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Neo4jEventPublicationAdapter
    implements TargetEventPublication {
        private final Neo4jEventPublication delegate;

        public Neo4jEventPublicationAdapter(Neo4jEventPublication delegate) {
            this.delegate = delegate;
        }

        public UUID getIdentifier() {
            return this.delegate.identifier;
        }

        public Object getEvent() {
            return this.delegate.event;
        }

        public Instant getPublicationDate() {
            return this.delegate.publicationDate;
        }

        public Optional<Instant> getCompletionDate() {
            return Optional.ofNullable(this.delegate.completionDate);
        }

        public void markCompleted(Instant instant) {
            this.delegate.completionDate = instant;
        }

        public PublicationTargetIdentifier getTargetIdentifier() {
            return PublicationTargetIdentifier.of((String)this.delegate.listenerId);
        }

        public boolean isPublicationCompleted() {
            return this.delegate.completionDate != null;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Neo4jEventPublicationAdapter)) {
                return false;
            }
            Neo4jEventPublicationAdapter that = (Neo4jEventPublicationAdapter)obj;
            return Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

