/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.common.signature;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.oauth.common.signature.InvalidSignatureException;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethod;

public class RSA_SHA1SignatureMethod
implements OAuthSignatureMethod {
    public static final String SIGNATURE_NAME = "RSA-SHA1";
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public RSA_SHA1SignatureMethod(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public RSA_SHA1SignatureMethod(PrivateKey key) {
        this(key, null);
    }

    public RSA_SHA1SignatureMethod(PublicKey key) {
        this(null, key);
    }

    @Override
    public String getName() {
        return SIGNATURE_NAME;
    }

    @Override
    public String sign(String signatureBaseString) {
        if (this.privateKey == null) {
            throw new UnsupportedOperationException("Cannot sign the base string: no private key supplied.");
        }
        try {
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(this.privateKey);
            signer.update(signatureBaseString.getBytes("UTF-8"));
            byte[] signatureBytes = signer.sign();
            signatureBytes = Base64.encodeBase64((byte[])signatureBytes);
            return new String(signatureBytes, "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void verify(String signatureBaseString, String signature) throws InvalidSignatureException {
        if (this.publicKey == null) {
            throw new UnsupportedOperationException("A public key must be provided to verify signatures.");
        }
        try {
            byte[] signatureBytes = Base64.decodeBase64((byte[])signature.getBytes("UTF-8"));
            Signature verifier = Signature.getInstance("SHA1withRSA");
            verifier.initVerify(this.publicKey);
            verifier.update(signatureBaseString.getBytes("UTF-8"));
            if (!verifier.verify(signatureBytes)) {
                throw new InvalidSignatureException("Invalid signature for signature method " + this.getName());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

