/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth.provider.filter.UserAuthorizationProcessingFilter;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class UserAuthorizationSuccessfulAuthenticationHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private static Log LOG = LogFactory.getLog(UserAuthorizationSuccessfulAuthenticationHandler.class);
    private String tokenIdParameterName = "requestToken";
    private String callbackParameterName = "callbackURL";
    private boolean require10a = true;

    public UserAuthorizationSuccessfulAuthenticationHandler() {
        this.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
    }

    public UserAuthorizationSuccessfulAuthenticationHandler(String s) {
        super(s);
        this.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String callbackURL;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Processing successful authentication successful");
        }
        if ((callbackURL = (String)request.getAttribute(UserAuthorizationProcessingFilter.CALLBACK_ATTRIBUTE)) == null) {
            if (!this.isRequire10a()) {
                callbackURL = request.getParameter(this.getCallbackParameterName());
                if (callbackURL == null) {
                    callbackURL = "oob";
                }
            } else {
                throw new IllegalStateException("Callback URL was not loaded into the request. attemptAuthentication() never called?");
            }
        }
        if ("oob".equals(callbackURL)) {
            callbackURL = super.determineTargetUrl(request, response);
        }
        String requestToken = request.getParameter(this.getTokenParameterName());
        char appendChar = '?';
        if (callbackURL.indexOf(63) > 0) {
            appendChar = '&';
        }
        String verifier = (String)request.getAttribute(UserAuthorizationProcessingFilter.VERIFIER_ATTRIBUTE);
        String targetUrl = callbackURL + appendChar + "oauth_token=" + requestToken + "&oauth_verifier=" + verifier;
        this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
    }

    public String getTokenParameterName() {
        return this.tokenIdParameterName;
    }

    public void setTokenIdParameterName(String tokenIdParameterName) {
        this.tokenIdParameterName = tokenIdParameterName;
    }

    public boolean isRequire10a() {
        return this.require10a;
    }

    public void setRequire10a(boolean require10a) {
        this.require10a = require10a;
    }

    public String getCallbackParameterName() {
        return this.callbackParameterName;
    }

    public void setCallbackParameterName(String callbackParameterName) {
        this.callbackParameterName = callbackParameterName;
    }
}

