/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.cas;

import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.cas.CasAuthenticationProvider;
import org.springframework.security.providers.cas.CasAuthenticationToken;
import org.springframework.security.providers.cas.StatelessTicketCache;
import org.springframework.security.ui.cas.ServiceProperties;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;

public class CasAuthenticationProviderTests {
    private UserDetails makeUserDetails() {
        return new User("user", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    private UserDetails makeUserDetailsFromAuthoritiesPopulator() {
        return new User("user", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")});
    }

    private ServiceProperties makeServiceProperties() {
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setSendRenew(false);
        serviceProperties.setService("http://test.com");
        return serviceProperties;
    }

    @Test
    public void statefulAuthenticationIsSuccessful() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setServiceProperties(this.makeServiceProperties());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"_cas_stateful_", (Object)"ST-123");
        token.setDetails((Object)"details");
        Authentication result = cap.authenticate((Authentication)token);
        Assert.assertTrue((cache.getByTicketId("ST-456") == null ? 1 : 0) != 0);
        if (!(result instanceof CasAuthenticationToken)) {
            Assert.fail((String)"Should have returned a CasAuthenticationToken");
        }
        CasAuthenticationToken casResult = (CasAuthenticationToken)result;
        Assert.assertEquals((Object)this.makeUserDetailsFromAuthoritiesPopulator(), (Object)casResult.getPrincipal());
        Assert.assertEquals((Object)"ST-123", (Object)casResult.getCredentials());
        Assert.assertEquals((Object)new GrantedAuthorityImpl("ROLE_A"), (Object)casResult.getAuthorities()[0]);
        Assert.assertEquals((Object)new GrantedAuthorityImpl("ROLE_B"), (Object)casResult.getAuthorities()[1]);
        Assert.assertEquals((long)cap.getKey().hashCode(), (long)casResult.getKeyHash());
        Assert.assertEquals((Object)"details", (Object)casResult.getDetails());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(false));
        Authentication laterResult = cap.authenticate(result);
        Assert.assertEquals((Object)result, (Object)laterResult);
    }

    @Test
    public void statelessAuthenticationIsSuccessful() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"_cas_stateless_", (Object)"ST-456");
        token.setDetails((Object)"details");
        Authentication result = cap.authenticate((Authentication)token);
        Assert.assertTrue((cache.getByTicketId("ST-456") != null ? 1 : 0) != 0);
        if (!(result instanceof CasAuthenticationToken)) {
            Assert.fail((String)"Should have returned a CasAuthenticationToken");
        }
        Assert.assertEquals((Object)this.makeUserDetailsFromAuthoritiesPopulator(), (Object)result.getPrincipal());
        Assert.assertEquals((Object)"ST-456", (Object)result.getCredentials());
        Assert.assertEquals((Object)"details", (Object)result.getDetails());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(false));
        Authentication newResult = cap.authenticate((Authentication)token);
        Assert.assertEquals((Object)this.makeUserDetailsFromAuthoritiesPopulator(), (Object)newResult.getPrincipal());
        Assert.assertEquals((Object)"ST-456", (Object)newResult.getCredentials());
    }

    @Test(expected=BadCredentialsException.class)
    public void missingTicketIdIsDetected() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"_cas_stateful_", (Object)"");
        Authentication result = cap.authenticate((Authentication)token);
    }

    @Test(expected=BadCredentialsException.class)
    public void invalidKeyIsDetected() throws Exception {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
        CasAuthenticationToken token = new CasAuthenticationToken("WRONG_KEY", (Object)this.makeUserDetails(), (Object)"credentials", new GrantedAuthority[]{new GrantedAuthorityImpl("XX")}, this.makeUserDetails(), (Assertion)assertion);
        cap.authenticate((Authentication)token);
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectsMissingAuthoritiesPopulator() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectsMissingKey() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectsMissingStatelessTicketCache() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setStatelessTicketCache(null);
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectsMissingTicketValidator() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
    }

    @Test
    public void gettersAndSettersMatch() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
        Assert.assertTrue((cap.getUserDetailsService() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"qwerty", (Object)cap.getKey());
        Assert.assertTrue((cap.getStatelessTicketCache() != null ? 1 : 0) != 0);
        Assert.assertTrue((cap.getTicketValidator() != null ? 1 : 0) != 0);
    }

    @Test
    public void ignoresClassesItDoesNotSupport() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        Assert.assertFalse((boolean)cap.supports(TestingAuthenticationToken.class));
        Assert.assertEquals(null, (Object)cap.authenticate((Authentication)token));
    }

    @Test
    public void ignoresUsernamePasswordAuthenticationTokensWithoutCasIdentifiersAsPrincipal() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setUserDetailsService((UserDetailsService)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.setServiceProperties(this.makeServiceProperties());
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"some_normal_user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        Assert.assertEquals(null, (Object)cap.authenticate((Authentication)token));
    }

    @Test
    public void supportsRequiredTokens() {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        Assert.assertTrue((boolean)cap.supports(UsernamePasswordAuthenticationToken.class));
        Assert.assertTrue((boolean)cap.supports(CasAuthenticationToken.class));
    }

    private class MockTicketValidator
    implements TicketValidator {
        private boolean returnTicket;

        public MockTicketValidator(boolean returnTicket) {
            this.returnTicket = returnTicket;
        }

        public Assertion validate(String ticket, String service) throws TicketValidationException {
            if (this.returnTicket) {
                return new AssertionImpl("rod");
            }
            throw new BadCredentialsException("As requested from mock");
        }
    }

    private class MockStatelessTicketCache
    implements StatelessTicketCache {
        private Map cache = new HashMap();

        private MockStatelessTicketCache() {
        }

        public CasAuthenticationToken getByTicketId(String serviceTicket) {
            return (CasAuthenticationToken)this.cache.get(serviceTicket);
        }

        public void putTicketInCache(CasAuthenticationToken token) {
            this.cache.put(token.getCredentials().toString(), token);
        }

        public void removeTicketFromCache(CasAuthenticationToken token) {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public void removeTicketFromCache(String serviceTicket) {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }

    private class MockAuthoritiesPopulator
    implements UserDetailsService {
        private MockAuthoritiesPopulator() {
        }

        public UserDetails loadUserByUsername(String casUserId) throws AuthenticationException {
            return CasAuthenticationProviderTests.this.makeUserDetailsFromAuthoritiesPopulator();
        }
    }
}

