/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.cas;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.cas.CasAuthenticationToken;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;

public class CasAuthenticationTokenTests
extends TestCase {
    public CasAuthenticationTokenTests() {
    }

    public CasAuthenticationTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(CasAuthenticationTokenTests.class);
    }

    private UserDetails makeUserDetails() {
        return this.makeUserDetails("user");
    }

    private UserDetails makeUserDetails(String name) {
        return new User(name, "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructorRejectsNulls() {
        AssertionImpl assertion = new AssertionImpl("test");
        try {
            new CasAuthenticationToken(null, (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", null, (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), null, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", null, this.makeUserDetails(), (Assertion)assertion);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), null);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, null, (Assertion)assertion);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), null, new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testEqualsWhenEqual() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationTokenTests.assertEquals((Object)token1, (Object)token2);
    }

    public void testGetters() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationTokenTests.assertEquals((int)"key".hashCode(), (int)token.getKeyHash());
        CasAuthenticationTokenTests.assertEquals((Object)this.makeUserDetails(), (Object)token.getPrincipal());
        CasAuthenticationTokenTests.assertEquals((Object)"Password", (Object)token.getCredentials());
        CasAuthenticationTokenTests.assertEquals((String)"ROLE_ONE", (String)token.getAuthorities()[0].getAuthority());
        CasAuthenticationTokenTests.assertEquals((String)"ROLE_TWO", (String)token.getAuthorities()[1].getAuthority());
        CasAuthenticationTokenTests.assertEquals((Object)assertion, (Object)token.getAssertion());
        CasAuthenticationTokenTests.assertEquals((String)this.makeUserDetails().getUsername(), (String)token.getUserDetails().getUsername());
    }

    public void testNoArgConstructorDoesntExist() {
        Class<CasAuthenticationToken> clazz = CasAuthenticationToken.class;
        try {
            clazz.getDeclaredConstructor(null);
            CasAuthenticationTokenTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testNotEqualsDueToAbstractParentEqualsCheck() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails("OTHER_NAME"), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToDifferentAuthenticationClass() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        UsernamePasswordAuthenticationToken token2 = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToKey() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationToken token2 = new CasAuthenticationToken("DIFFERENT_KEY", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToAssertion() {
        AssertionImpl assertion = new AssertionImpl("test");
        AssertionImpl assertion2 = new AssertionImpl("test");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion2);
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testSetAuthenticated() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        CasAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
        token.setAuthenticated(false);
        CasAuthenticationTokenTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
    }

    public void testToString() {
        AssertionImpl assertion = new AssertionImpl("test");
        CasAuthenticationToken token = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), (Assertion)assertion);
        String result = token.toString();
        CasAuthenticationTokenTests.assertTrue((result.lastIndexOf("Credentials (Service/Proxy Ticket):") != -1 ? 1 : 0) != 0);
    }
}

