/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.cas.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.security.providers.cas.CasAuthenticationToken;
import org.springframework.security.providers.cas.cache.AbstractStatelessTicketCacheTests;
import org.springframework.security.providers.cas.cache.EhCacheBasedTicketCache;

public class EhCacheBasedTicketCacheTests
extends AbstractStatelessTicketCacheTests {
    private static CacheManager cacheManager;

    @BeforeClass
    public static void initCacheManaer() {
        cacheManager = new CacheManager();
        cacheManager.addCache(new Cache("castickets", 500, false, false, 30L, 30L));
    }

    @AfterClass
    public static void shutdownCacheManager() {
        cacheManager.removalAll();
        cacheManager.shutdown();
    }

    @Test
    public void testCacheOperation() throws Exception {
        EhCacheBasedTicketCache cache = new EhCacheBasedTicketCache();
        cache.setCache((Ehcache)cacheManager.getCache("castickets"));
        cache.afterPropertiesSet();
        CasAuthenticationToken token = this.getToken();
        cache.putTicketInCache(token);
        Assert.assertEquals((Object)token, (Object)cache.getByTicketId("ST-0-ER94xMJmn6pha35CQRoZ"));
        cache.removeTicketFromCache(this.getToken());
        Assert.assertNull((Object)cache.getByTicketId("ST-0-ER94xMJmn6pha35CQRoZ"));
        Assert.assertNull((Object)cache.getByTicketId(null));
        Assert.assertNull((Object)cache.getByTicketId("UNKNOWN_SERVICE_TICKET"));
    }

    @Test
    public void testStartupDetectsMissingCache() throws Exception {
        EhCacheBasedTicketCache cache = new EhCacheBasedTicketCache();
        try {
            cache.afterPropertiesSet();
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)true);
        }
        Cache myCache = cacheManager.getCache("castickets");
        cache.setCache((Ehcache)myCache);
        Assert.assertEquals((Object)myCache, (Object)cache.getCache());
    }
}

