/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.cas;

import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ui.cas.CasProcessingFilterEntryPoint;
import org.springframework.security.ui.cas.ServiceProperties;

public class CasProcessingFilterEntryPointTests
extends TestCase {
    public CasProcessingFilterEntryPointTests() {
    }

    public CasProcessingFilterEntryPointTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(CasProcessingFilterEntryPointTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingLoginFormUrl() throws Exception {
        CasProcessingFilterEntryPoint ep = new CasProcessingFilterEntryPoint();
        ep.setServiceProperties(new ServiceProperties());
        try {
            ep.afterPropertiesSet();
            CasProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasProcessingFilterEntryPointTests.assertEquals((String)"loginUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingServiceProperties() throws Exception {
        CasProcessingFilterEntryPoint ep = new CasProcessingFilterEntryPoint();
        ep.setLoginUrl("https://cas/login");
        try {
            ep.afterPropertiesSet();
            CasProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasProcessingFilterEntryPointTests.assertEquals((String)"serviceProperties must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        CasProcessingFilterEntryPoint ep = new CasProcessingFilterEntryPoint();
        ep.setLoginUrl("https://cas/login");
        CasProcessingFilterEntryPointTests.assertEquals((String)"https://cas/login", (String)ep.getLoginUrl());
        ep.setServiceProperties(new ServiceProperties());
        CasProcessingFilterEntryPointTests.assertTrue((ep.getServiceProperties() != null ? 1 : 0) != 0);
    }

    public void testNormalOperationWithRenewFalse() throws Exception {
        ServiceProperties sp = new ServiceProperties();
        sp.setSendRenew(false);
        sp.setService("https://mycompany.com/bigWebApp/j_spring_cas_security_check");
        CasProcessingFilterEntryPoint ep = new CasProcessingFilterEntryPoint();
        ep.setLoginUrl("https://cas/login");
        ep.setServiceProperties(sp);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        CasProcessingFilterEntryPointTests.assertEquals((String)("https://cas/login?service=" + URLEncoder.encode("https://mycompany.com/bigWebApp/j_spring_cas_security_check", "UTF-8")), (String)response.getRedirectedUrl());
    }

    public void testNormalOperationWithRenewTrue() throws Exception {
        ServiceProperties sp = new ServiceProperties();
        sp.setSendRenew(true);
        sp.setService("https://mycompany.com/bigWebApp/j_spring_cas_security_check");
        CasProcessingFilterEntryPoint ep = new CasProcessingFilterEntryPoint();
        ep.setLoginUrl("https://cas/login");
        ep.setServiceProperties(sp);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        CasProcessingFilterEntryPointTests.assertEquals((String)("https://cas/login?service=" + URLEncoder.encode("https://mycompany.com/bigWebApp/j_spring_cas_security_check", "UTF-8") + "&renew=true"), (String)response.getRedirectedUrl());
    }
}

