/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.cas;

import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.ui.cas.CasProcessingFilter;

public class CasProcessingFilterTests
extends TestCase {
    public CasProcessingFilterTests() {
    }

    public CasProcessingFilterTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(CasProcessingFilterTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testGetters() {
        CasProcessingFilter filter = new CasProcessingFilter();
        CasProcessingFilterTests.assertEquals((String)"/j_spring_cas_security_check", (String)filter.getDefaultFilterProcessesUrl());
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("ticket", "ST-0-ER94xMJmn6pha35CQRoZ");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        CasProcessingFilter filter = new CasProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        CasProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testNullServiceTicketHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockAuthenticationManager authMgr = new MockAuthenticationManager(false);
        CasProcessingFilter filter = new CasProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        try {
            filter.attemptAuthentication((HttpServletRequest)request);
            CasProcessingFilterTests.fail((String)"Should have thrown AuthenticationException");
        }
        catch (AuthenticationException expected) {
            CasProcessingFilterTests.assertTrue((boolean)true);
        }
    }
}

