/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractConfigAttributeRequestMatcherRegistry;
import org.springframework.security.config.annotation.web.configurers.AbstractInterceptUrlConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ExpressionUrlAuthorizationConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractInterceptUrlConfigurer<ExpressionUrlAuthorizationConfigurer<H>, H> {
    static final String permitAll = "permitAll";
    private static final String denyAll = "denyAll";
    private static final String anonymous = "anonymous";
    private static final String authenticated = "authenticated";
    private static final String fullyAuthenticated = "fullyAuthenticated";
    private static final String rememberMe = "rememberMe";
    private final String rolePrefix;
    private final ExpressionInterceptUrlRegistry REGISTRY;
    private SecurityExpressionHandler<FilterInvocation> expressionHandler;

    public ExpressionUrlAuthorizationConfigurer(ApplicationContext context) {
        String[] grantedAuthorityDefaultsBeanNames = context.getBeanNamesForType(GrantedAuthorityDefaults.class);
        if (grantedAuthorityDefaultsBeanNames.length == 1) {
            GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)context.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
            this.rolePrefix = grantedAuthorityDefaults.getRolePrefix();
        } else {
            this.rolePrefix = "ROLE_";
        }
        this.REGISTRY = new ExpressionInterceptUrlRegistry(context);
    }

    public ExpressionInterceptUrlRegistry getRegistry() {
        return this.REGISTRY;
    }

    private void interceptUrl(Iterable<? extends RequestMatcher> requestMatchers, Collection<ConfigAttribute> configAttributes) {
        for (RequestMatcher requestMatcher : requestMatchers) {
            this.REGISTRY.addMapping(new AbstractConfigAttributeRequestMatcherRegistry.UrlMapping(requestMatcher, configAttributes));
        }
    }

    @Override
    List<AccessDecisionVoter<?>> getDecisionVoters(H http) {
        ArrayList decisionVoters = new ArrayList();
        WebExpressionVoter expressionVoter = new WebExpressionVoter();
        expressionVoter.setExpressionHandler(this.getExpressionHandler(http));
        decisionVoters.add((AccessDecisionVoter<?>)expressionVoter);
        return decisionVoters;
    }

    ExpressionBasedFilterInvocationSecurityMetadataSource createMetadataSource(H http) {
        LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = this.REGISTRY.createRequestMap();
        Assert.state((!requestMap.isEmpty() ? 1 : 0) != 0, (String)"At least one mapping is required (i.e. authorizeRequests().anyRequest().authenticated())");
        return new ExpressionBasedFilterInvocationSecurityMetadataSource(requestMap, this.getExpressionHandler(http));
    }

    private SecurityExpressionHandler<FilterInvocation> getExpressionHandler(H http) {
        ApplicationContext context;
        if (this.expressionHandler != null) {
            return this.expressionHandler;
        }
        DefaultWebSecurityExpressionHandler defaultHandler = new DefaultWebSecurityExpressionHandler();
        AuthenticationTrustResolver trustResolver = http.getSharedObject(AuthenticationTrustResolver.class);
        if (trustResolver != null) {
            defaultHandler.setTrustResolver(trustResolver);
        }
        if ((context = http.getSharedObject(ApplicationContext.class)) != null) {
            String[] permissionEvaluatorBeanNames;
            String[] grantedAuthorityDefaultsBeanNames;
            String[] roleHiearchyBeanNames = context.getBeanNamesForType(RoleHierarchy.class);
            if (roleHiearchyBeanNames.length == 1) {
                defaultHandler.setRoleHierarchy((RoleHierarchy)context.getBean(roleHiearchyBeanNames[0], RoleHierarchy.class));
            }
            if ((grantedAuthorityDefaultsBeanNames = context.getBeanNamesForType(GrantedAuthorityDefaults.class)).length == 1) {
                GrantedAuthorityDefaults grantedAuthorityDefaults = (GrantedAuthorityDefaults)context.getBean(grantedAuthorityDefaultsBeanNames[0], GrantedAuthorityDefaults.class);
                defaultHandler.setDefaultRolePrefix(grantedAuthorityDefaults.getRolePrefix());
            }
            if ((permissionEvaluatorBeanNames = context.getBeanNamesForType(PermissionEvaluator.class)).length == 1) {
                PermissionEvaluator permissionEvaluator = (PermissionEvaluator)context.getBean(permissionEvaluatorBeanNames[0], PermissionEvaluator.class);
                defaultHandler.setPermissionEvaluator(permissionEvaluator);
            }
        }
        this.expressionHandler = (SecurityExpressionHandler)this.postProcess(defaultHandler);
        return this.expressionHandler;
    }

    private static String hasAnyRole(String rolePrefix, String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)("','" + rolePrefix));
        return "hasAnyRole('" + rolePrefix + anyAuthorities + "')";
    }

    private static String hasRole(String rolePrefix, String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        Assert.isTrue((rolePrefix.isEmpty() || !role.startsWith(rolePrefix) ? 1 : 0) != 0, () -> "role should not start with '" + rolePrefix + "' since it is automatically inserted. Got '" + role + "'");
        return "hasRole('" + rolePrefix + role + "')";
    }

    private static String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private static String hasAnyAuthority(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    private static String hasIpAddress(String ipAddressExpression) {
        return "hasIpAddress('" + ipAddressExpression + "')";
    }

    public class AuthorizedUrl {
        private List<? extends RequestMatcher> requestMatchers;
        private boolean not;

        AuthorizedUrl(List<? extends RequestMatcher> requestMatchers) {
            this.requestMatchers = requestMatchers;
        }

        protected List<? extends RequestMatcher> getMatchers() {
            return this.requestMatchers;
        }

        public AuthorizedUrl not() {
            this.not = true;
            return this;
        }

        public ExpressionInterceptUrlRegistry hasRole(String role) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasRole(ExpressionUrlAuthorizationConfigurer.this.rolePrefix, role));
        }

        public ExpressionInterceptUrlRegistry hasAnyRole(String ... roles) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasAnyRole(ExpressionUrlAuthorizationConfigurer.this.rolePrefix, roles));
        }

        public ExpressionInterceptUrlRegistry hasAuthority(String authority) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasAuthority(authority));
        }

        public ExpressionInterceptUrlRegistry hasAnyAuthority(String ... authorities) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasAnyAuthority(authorities));
        }

        public ExpressionInterceptUrlRegistry hasIpAddress(String ipaddressExpression) {
            return this.access(ExpressionUrlAuthorizationConfigurer.hasIpAddress(ipaddressExpression));
        }

        public ExpressionInterceptUrlRegistry permitAll() {
            return this.access(ExpressionUrlAuthorizationConfigurer.permitAll);
        }

        public ExpressionInterceptUrlRegistry anonymous() {
            return this.access(ExpressionUrlAuthorizationConfigurer.anonymous);
        }

        public ExpressionInterceptUrlRegistry rememberMe() {
            return this.access(ExpressionUrlAuthorizationConfigurer.rememberMe);
        }

        public ExpressionInterceptUrlRegistry denyAll() {
            return this.access(ExpressionUrlAuthorizationConfigurer.denyAll);
        }

        public ExpressionInterceptUrlRegistry authenticated() {
            return this.access(ExpressionUrlAuthorizationConfigurer.authenticated);
        }

        public ExpressionInterceptUrlRegistry fullyAuthenticated() {
            return this.access(ExpressionUrlAuthorizationConfigurer.fullyAuthenticated);
        }

        public ExpressionInterceptUrlRegistry access(String attribute) {
            if (this.not) {
                attribute = "!" + attribute;
            }
            ExpressionUrlAuthorizationConfigurer.this.interceptUrl(this.requestMatchers, SecurityConfig.createList((String[])new String[]{attribute}));
            return ExpressionUrlAuthorizationConfigurer.this.REGISTRY;
        }
    }

    public final class MvcMatchersAuthorizedUrl
    extends AuthorizedUrl {
        private MvcMatchersAuthorizedUrl(List<MvcRequestMatcher> requestMatchers) {
            super(requestMatchers);
        }

        public AuthorizedUrl servletPath(String servletPath) {
            for (MvcRequestMatcher mvcRequestMatcher : this.getMatchers()) {
                mvcRequestMatcher.setServletPath(servletPath);
            }
            return this;
        }
    }

    public final class ExpressionInterceptUrlRegistry
    extends AbstractInterceptUrlConfigurer.AbstractInterceptUrlRegistry<ExpressionInterceptUrlRegistry, AuthorizedUrl> {
        private ExpressionInterceptUrlRegistry(ApplicationContext context) {
            super(ExpressionUrlAuthorizationConfigurer.this);
            this.setApplicationContext(context);
        }

        @Override
        public MvcMatchersAuthorizedUrl mvcMatchers(HttpMethod method, String ... mvcPatterns) {
            return new MvcMatchersAuthorizedUrl(this.createMvcMatchers(method, mvcPatterns));
        }

        @Override
        public MvcMatchersAuthorizedUrl mvcMatchers(String ... patterns) {
            return this.mvcMatchers((HttpMethod)null, patterns);
        }

        @Override
        protected AuthorizedUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
            return new AuthorizedUrl(requestMatchers);
        }

        public ExpressionInterceptUrlRegistry expressionHandler(SecurityExpressionHandler<FilterInvocation> expressionHandler) {
            ExpressionUrlAuthorizationConfigurer.this.expressionHandler = expressionHandler;
            return this;
        }

        public ExpressionInterceptUrlRegistry withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            ExpressionUrlAuthorizationConfigurer.this.addObjectPostProcessor(objectPostProcessor);
            return this;
        }

        public H and() {
            return (HttpSecurityBuilder)ExpressionUrlAuthorizationConfigurer.this.and();
        }
    }
}

