/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.access.intercept;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.InterceptorStatusToken;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelSecurityInterceptor
extends AbstractSecurityInterceptor
implements ChannelInterceptor {
    private static final ThreadLocal<InterceptorStatusToken> tokenHolder = new ThreadLocal();
    private final MessageSecurityMetadataSource metadataSource;

    public ChannelSecurityInterceptor(MessageSecurityMetadataSource metadataSource) {
        Assert.notNull((Object)metadataSource, (String)"metadataSource cannot be null");
        this.metadataSource = metadataSource;
    }

    public Class<?> getSecureObjectClass() {
        return Message.class;
    }

    public SecurityMetadataSource obtainSecurityMetadataSource() {
        return this.metadataSource;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        InterceptorStatusToken token = this.beforeInvocation(message);
        if (token != null) {
            tokenHolder.set(token);
        }
        return message;
    }

    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
        InterceptorStatusToken token = this.clearToken();
        this.afterInvocation(token, null);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        InterceptorStatusToken token = this.clearToken();
        this.finallyInvocation(token);
    }

    public boolean preReceive(MessageChannel channel) {
        return true;
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        return message;
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
    }

    private InterceptorStatusToken clearToken() {
        InterceptorStatusToken token = tokenHolder.get();
        tokenHolder.remove();
        return token;
    }
}

