/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.remoting.httpinvoker;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationSimpleHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor {
    private static final Log logger = LogFactory.getLog(AuthenticationSimpleHttpInvokerRequestExecutor.class);
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    protected void doPrepareConnection(HttpURLConnection con, int contentLength) throws IOException {
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        super.prepareConnection(con, contentLength);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getName() != null && auth.getCredentials() != null && !this.trustResolver.isAnonymous(auth)) {
            String base64 = auth.getName() + ":" + auth.getCredentials().toString();
            con.setRequestProperty("Authorization", "Basic " + new String(Base64.getEncoder().encode(base64.getBytes())));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HttpInvocation now presenting via BASIC authentication SecurityContextHolder-derived: " + auth.toString()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unable to set BASIC authentication header as SecurityContext did not provide valid Authentication: " + auth));
        }
        this.doPrepareConnection(con, contentLength);
    }
}

