/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.firewall.FirewalledRequest;
import org.springframework.security.web.firewall.HttpFirewall;

public class FilterChainProxyTests {
    private FilterChainProxy fcp;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private FilterChain chain;
    private Filter filter;

    @Before
    public void setup() throws Exception {
        this.fcp = new FilterChainProxy();
        this.filter = (Filter)Mockito.mock(Filter.class);
        ((Filter)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock inv) throws Throwable {
                Object[] args = inv.getArguments();
                FilterChain fc = (FilterChain)args[2];
                fc.doFilter((ServletRequest)((HttpServletRequest)args[0]), (ServletResponse)((HttpServletResponse)args[1]));
                return null;
            }
        }).when((Object)this.filter)).doFilter((ServletRequest)Mockito.any(HttpServletRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class), (FilterChain)Mockito.any(FilterChain.class));
        LinkedHashMap<String, List<Filter>> map = new LinkedHashMap<String, List<Filter>>();
        map.put("/match", Arrays.asList(this.filter));
        this.fcp.setFilterChainMap(map);
        this.request = new MockHttpServletRequest();
        this.request.setServletPath("/match");
        this.response = new MockHttpServletResponse();
        this.chain = (FilterChain)Mockito.mock(FilterChain.class);
    }

    @Test
    public void toStringCallSucceeds() throws Exception {
        this.fcp.afterPropertiesSet();
        this.fcp.toString();
    }

    @Test
    public void securityFilterChainIsNotInvokedIfMatchFails() throws Exception {
        this.request.setServletPath("/nomatch");
        this.fcp.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertEquals((long)1L, (long)this.fcp.getFilterChainMap().size());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filter});
        ((FilterChain)Mockito.verify((Object)this.chain)).doFilter((ServletRequest)Mockito.any(HttpServletRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class));
    }

    @Test
    public void originalChainIsInvokedAfterSecurityChainIfMatchSucceeds() throws Exception {
        this.fcp.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((Filter)Mockito.verify((Object)this.filter)).doFilter((ServletRequest)Mockito.any(HttpServletRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class), (FilterChain)Mockito.any(FilterChain.class));
        ((FilterChain)Mockito.verify((Object)this.chain)).doFilter((ServletRequest)Mockito.any(HttpServletRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class));
    }

    @Test
    public void originalFilterChainIsInvokedIfMatchingSecurityChainIsEmpty() throws Exception {
        LinkedHashMap map = new LinkedHashMap();
        map.put("/match", Collections.emptyList());
        this.fcp.setFilterChainMap(map);
        this.fcp.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((FilterChain)Mockito.verify((Object)this.chain)).doFilter((ServletRequest)Mockito.any(HttpServletRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class));
    }

    @Test
    public void requestIsWrappedForFilteringWhenMatchIsFound() throws Exception {
        this.fcp.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((Filter)Mockito.verify((Object)this.filter)).doFilter((ServletRequest)Mockito.any(FirewalledRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class), (FilterChain)Mockito.any(FilterChain.class));
        ((FilterChain)Mockito.verify((Object)this.chain)).doFilter((ServletRequest)Mockito.any(FirewalledRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class));
    }

    @Test
    public void requestIsWrappedForFilteringWhenMatchIsNotFound() throws Exception {
        this.request.setServletPath("/nomatch");
        this.fcp.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filter});
        ((FilterChain)Mockito.verify((Object)this.chain)).doFilter((ServletRequest)Mockito.any(FirewalledRequest.class), (ServletResponse)Mockito.any(HttpServletResponse.class));
    }

    @Test
    public void wrapperIsResetWhenNoMatchingFilters() throws Exception {
        this.request.setServletPath("/nomatch");
        HttpFirewall fw = (HttpFirewall)Mockito.mock(HttpFirewall.class);
        FirewalledRequest fwr = (FirewalledRequest)Mockito.mock(FirewalledRequest.class);
        Mockito.when((Object)fwr.getRequestURI()).thenReturn((Object)"/");
        Mockito.when((Object)fwr.getContextPath()).thenReturn((Object)"");
        this.fcp.setFirewall(fw);
        Mockito.when((Object)fw.getFirewalledRequest((HttpServletRequest)this.request)).thenReturn((Object)fwr);
        this.fcp.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        ((FirewalledRequest)Mockito.verify((Object)fwr)).reset();
    }
}

