/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.access.intercept.RunAsManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.DummyRequest;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.UrlUtils;

public class DefaultWebInvocationPrivilegeEvaluatorTests {
    private AccessDecisionManager adm;
    private FilterInvocationSecurityMetadataSource ods;
    private RunAsManager ram;
    private FilterSecurityInterceptor interceptor;

    @Before
    public final void setUp() {
        this.interceptor = new FilterSecurityInterceptor();
        this.ods = (FilterInvocationSecurityMetadataSource)Mockito.mock(FilterInvocationSecurityMetadataSource.class);
        this.adm = (AccessDecisionManager)Mockito.mock(AccessDecisionManager.class);
        this.ram = (RunAsManager)Mockito.mock(RunAsManager.class);
        this.interceptor.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        this.interceptor.setSecurityMetadataSource(this.ods);
        this.interceptor.setAccessDecisionManager(this.adm);
        this.interceptor.setRunAsManager(this.ram);
        this.interceptor.setApplicationEventPublisher((ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class));
        SecurityContextHolder.clearContext();
    }

    @Test
    public void permitsAccessIfNoMatchingAttributesAndPublicInvocationsAllowed() throws Exception {
        DefaultWebInvocationPrivilegeEvaluator wipe = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)this.interceptor);
        Mockito.when((Object)this.ods.getAttributes(Mockito.anyObject())).thenReturn(null);
        Assert.assertTrue((boolean)wipe.isAllowed("/context", "/foo/index.jsp", "GET", (Authentication)Mockito.mock(Authentication.class)));
    }

    @Test
    public void deniesAccessIfNoMatchingAttributesAndPublicInvocationsNotAllowed() throws Exception {
        DefaultWebInvocationPrivilegeEvaluator wipe = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)this.interceptor);
        Mockito.when((Object)this.ods.getAttributes(Mockito.anyObject())).thenReturn(null);
        this.interceptor.setRejectPublicInvocations(true);
        Assert.assertFalse((boolean)wipe.isAllowed("/context", "/foo/index.jsp", "GET", (Authentication)Mockito.mock(Authentication.class)));
    }

    @Test
    public void deniesAccessIfAuthenticationIsNull() throws Exception {
        DefaultWebInvocationPrivilegeEvaluator wipe = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)this.interceptor);
        Assert.assertFalse((boolean)wipe.isAllowed("/foo/index.jsp", null));
    }

    @Test
    public void allowsAccessIfAccessDecisionMangerDoes() throws Exception {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"test", (Object)"Password", new String[]{"MOCK_INDEX"});
        DefaultWebInvocationPrivilegeEvaluator wipe = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)this.interceptor);
        Assert.assertTrue((boolean)wipe.isAllowed("/foo/index.jsp", (Authentication)token));
    }

    @Test
    public void deniesAccessIfAccessDecisionMangerDoes() throws Exception {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"test", (Object)"Password", new String[]{"MOCK_INDEX"});
        DefaultWebInvocationPrivilegeEvaluator wipe = new DefaultWebInvocationPrivilegeEvaluator((AbstractSecurityInterceptor)this.interceptor);
        ((AccessDecisionManager)Mockito.doThrow((Throwable)new AccessDeniedException("")).when((Object)this.adm)).decide((Authentication)Mockito.any(Authentication.class), Mockito.anyObject(), (Collection)Mockito.anyList());
        Assert.assertFalse((boolean)wipe.isAllowed("/foo/index.jsp", (Authentication)token));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void dummyChainRejectsInvocation() throws Exception {
        DefaultWebInvocationPrivilegeEvaluator.DUMMY_CHAIN.doFilter((ServletRequest)Mockito.mock(HttpServletRequest.class), (ServletResponse)Mockito.mock(HttpServletResponse.class));
    }

    @Test
    public void dummyRequestIsSupportedByUrlUtils() throws Exception {
        DummyRequest request = new DummyRequest();
        request.setContextPath("");
        request.setRequestURI("/something");
        UrlUtils.buildRequestUrl((HttpServletRequest)request);
    }
}

