/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockPortResolver;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.ThrowableAnalyzer;

public class ExceptionTranslationFilterTests {
    @After
    @Before
    public void clearContext() throws Exception {
        SecurityContextHolder.clearContext();
    }

    private static String getSavedRequestUrl(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        DefaultSavedRequest savedRequest = (DefaultSavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY");
        return savedRequest.getRedirectUrl();
    }

    @Test
    public void testAccessDeniedWhenAnonymous() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setServerPort(80);
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/secure/page.html");
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new AccessDeniedException("")).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("ignored", (Object)"ignored", AuthorityUtils.createAuthorityList((String[])new String[]{"IGNORED"})));
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        filter.setAuthenticationTrustResolver((AuthenticationTrustResolver)new AuthenticationTrustResolverImpl());
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Assert.assertEquals((Object)"/mycontext/login.jsp", (Object)response.getRedirectedUrl());
        Assert.assertEquals((Object)"http://www.example.com/mycontext/secure/page.html", (Object)ExceptionTranslationFilterTests.getSavedRequestUrl((HttpServletRequest)request));
    }

    @Test
    public void testAccessDeniedWhenNonAnonymous() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new AccessDeniedException("")).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        SecurityContextHolder.clearContext();
        AccessDeniedHandlerImpl adh = new AccessDeniedHandlerImpl();
        adh.setErrorPage("/error.jsp");
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        filter.setAccessDeniedHandler((AccessDeniedHandler)adh);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        Assert.assertEquals(AccessDeniedException.class, request.getAttribute("SPRING_SECURITY_403_EXCEPTION").getClass());
    }

    @Test
    public void testRedirectedToLoginFormAndSessionShowsOriginalTargetWhenAuthenticationException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setServerPort(80);
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/secure/page.html");
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new BadCredentialsException("")).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        filter.afterPropertiesSet();
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Assert.assertEquals((Object)"/mycontext/login.jsp", (Object)response.getRedirectedUrl());
        Assert.assertEquals((Object)"http://www.example.com/mycontext/secure/page.html", (Object)ExceptionTranslationFilterTests.getSavedRequestUrl((HttpServletRequest)request));
    }

    @Test
    public void testRedirectedToLoginFormAndSessionShowsOriginalTargetWithExoticPortWhenAuthenticationException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setServerPort(8080);
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/secure/page.html");
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new BadCredentialsException("")).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        filter.setRequestCache((RequestCache)requestCache);
        filter.afterPropertiesSet();
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Assert.assertEquals((Object)"/mycontext/login.jsp", (Object)response.getRedirectedUrl());
        Assert.assertEquals((Object)"http://www.example.com:8080/mycontext/secure/page.html", (Object)ExceptionTranslationFilterTests.getSavedRequestUrl((HttpServletRequest)request));
    }

    @Test
    public void testSavedRequestIsNotStoredForPostIfJustUseSaveRequestOnGetIsSet() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        HttpSessionRequestCache requestCache = new HttpSessionRequestCache();
        requestCache.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        requestCache.setJustUseSavedRequestOnGet(true);
        filter.setRequestCache((RequestCache)requestCache);
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        MockHttpServletRequest request = new MockHttpServletRequest();
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new BadCredentialsException("")).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        request.setMethod("POST");
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), fc);
        Assert.assertTrue((request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY") == null ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartupDetectsMissingAuthenticationEntryPoint() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setThrowableAnalyzer((ThrowableAnalyzer)Mockito.mock(ThrowableAnalyzer.class));
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartupDetectsMissingRequestCache() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        filter.setRequestCache(null);
    }

    public void testSuccessfulAccessGrant() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
    }

    @Test
    public void testThrowIOException() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        filter.afterPropertiesSet();
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new IOException()).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), fc);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException e) {
            Assert.assertNull((String)"The IOException thrown should not have been wrapped", (Object)e.getCause());
        }
    }

    @Test
    public void testThrowServletException() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint(this.mockEntryPoint());
        filter.afterPropertiesSet();
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ((FilterChain)Mockito.doThrow((Throwable)new ServletException()).when((Object)fc)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), fc);
            Assert.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException e) {
            Assert.assertNull((String)"The ServletException thrown should not have been wrapped", (Object)e.getCause());
        }
    }

    private AuthenticationEntryPoint mockEntryPoint() {
        return new AuthenticationEntryPoint(){

            public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
                response.sendRedirect(request.getContextPath() + "/login.jsp");
            }
        };
    }
}

