/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelProcessor;

public class ChannelDecisionManagerImplTests
extends TestCase {
    public void testCannotSetEmptyChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        try {
            cdm.setChannelProcessors(new Vector());
            cdm.afterPropertiesSet();
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertEquals((String)"A list of ChannelProcessors is required", (String)expected.getMessage());
        }
    }

    public void testCannotSetIncorrectObjectTypesIntoChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        Vector<String> list = new Vector<String>();
        list.add("THIS IS NOT A CHANNELPROCESSOR");
        try {
            cdm.setChannelProcessors(list);
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertTrue((boolean)true);
        }
    }

    public void testCannotSetNullChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        try {
            cdm.setChannelProcessors(null);
            cdm.afterPropertiesSet();
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertEquals((String)"A list of ChannelProcessors is required", (String)expected.getMessage());
        }
    }

    public void testDecideIsOperational() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", true);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        List cad = SecurityConfig.createList((String[])new String[]{"xyz"});
        cdm.decide(fi, (Collection)cad);
        ChannelDecisionManagerImplTests.assertTrue((boolean)fi.getResponse().isCommitted());
    }

    public void testAnyChannelAttributeCausesProcessorsToBeSkipped() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", true);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        cdm.decide(fi, (Collection)SecurityConfig.createList((String[])new String[]{"abc", "ANY_CHANNEL"}));
        ChannelDecisionManagerImplTests.assertFalse((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideIteratesAllProcessorsIfNoneCommitAResponse() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", false);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        cdm.decide(fi, (Collection)SecurityConfig.createList((String[])new String[]{"SOME_ATTRIBUTE_NO_PROCESSORS_SUPPORT"}));
        ChannelDecisionManagerImplTests.assertFalse((boolean)fi.getResponse().isCommitted());
    }

    public void testDelegatesSupports() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", false);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        ChannelDecisionManagerImplTests.assertTrue((boolean)cdm.supports((ConfigAttribute)new SecurityConfig("xyz")));
        ChannelDecisionManagerImplTests.assertTrue((boolean)cdm.supports((ConfigAttribute)new SecurityConfig("abc")));
        ChannelDecisionManagerImplTests.assertFalse((boolean)cdm.supports((ConfigAttribute)new SecurityConfig("UNSUPPORTED")));
    }

    public void testGettersSetters() {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        ChannelDecisionManagerImplTests.assertNull((Object)cdm.getChannelProcessors());
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", false);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        ChannelDecisionManagerImplTests.assertEquals(list, (Object)cdm.getChannelProcessors());
    }

    public void testStartupFailsWithEmptyChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        try {
            cdm.afterPropertiesSet();
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertEquals((String)"A list of ChannelProcessors is required", (String)expected.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockChannelProcessor
    implements ChannelProcessor {
        private String configAttribute;
        private boolean failIfCalled;

        public MockChannelProcessor(String configAttribute, boolean failIfCalled) {
            this.configAttribute = configAttribute;
            this.failIfCalled = failIfCalled;
        }

        public void decide(FilterInvocation invocation, Collection<ConfigAttribute> config) throws IOException, ServletException {
            Iterator<ConfigAttribute> iter = config.iterator();
            if (this.failIfCalled) {
                Assert.fail((String)("Should not have called this channel processor: " + this.configAttribute));
            }
            while (iter.hasNext()) {
                ConfigAttribute attr = iter.next();
                if (!attr.getAttribute().equals(this.configAttribute)) continue;
                invocation.getHttpResponse().sendRedirect("/redirected");
                return;
            }
        }

        public boolean supports(ConfigAttribute attribute) {
            return attribute.getAttribute().equals(this.configAttribute);
        }
    }
}

