/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.channel.ChannelDecisionManager;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;

public class ChannelProcessingFilterTests {
    @Test(expected=IllegalArgumentException.class)
    public void testDetectsMissingChannelDecisionManager() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", true, "MOCK");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsMissingFilterInvocationSecurityMetadataSource() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "MOCK"));
        filter.afterPropertiesSet();
    }

    @Test
    public void testDetectsSupportedConfigAttribute() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "SUPPORTS_MOCK_ONLY"));
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", true, "SUPPORTS_MOCK_ONLY");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsUnsupportedConfigAttribute() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "SUPPORTS_MOCK_ONLY"));
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", true, "SUPPORTS_MOCK_ONLY", "INVALID_ATTRIBUTE");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        filter.afterPropertiesSet();
    }

    @Test
    public void testDoFilterWhenManagerDoesCommitResponse() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(true, "SOME_ATTRIBUTE"));
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", true, "SOME_ATTRIBUTE");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=now");
        request.setServletPath("/path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
    }

    @Test
    public void testDoFilterWhenManagerDoesNotCommitResponse() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "SOME_ATTRIBUTE"));
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", true, "SOME_ATTRIBUTE");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=now");
        request.setServletPath("/path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
    }

    @Test
    public void testDoFilterWhenNullConfigAttributeReturned() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "NOT_USED"));
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", true, "NOT_USED");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=now");
        request.setServletPath("/PATH_NOT_MATCHING_CONFIG_ATTRIBUTE");
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
    }

    @Test
    public void testGetterSetters() throws Exception {
        ChannelProcessingFilter filter = new ChannelProcessingFilter();
        filter.setChannelDecisionManager((ChannelDecisionManager)new MockChannelDecisionManager(false, "MOCK"));
        Assert.assertTrue((filter.getChannelDecisionManager() != null ? 1 : 0) != 0);
        MockFilterInvocationDefinitionMap fids = new MockFilterInvocationDefinitionMap("/path", false, "MOCK");
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)fids);
        Assert.assertSame((Object)fids, (Object)filter.getSecurityMetadataSource());
        filter.afterPropertiesSet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockFilterInvocationDefinitionMap
    implements FilterInvocationSecurityMetadataSource {
        private Collection<ConfigAttribute> toReturn;
        private String servletPath;
        private boolean provideIterator;

        public MockFilterInvocationDefinitionMap(String servletPath, boolean provideIterator, String ... toReturn) {
            this.servletPath = servletPath;
            this.toReturn = SecurityConfig.createList((String[])toReturn);
            this.provideIterator = provideIterator;
        }

        public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
            FilterInvocation fi = (FilterInvocation)object;
            if (this.servletPath.equals(fi.getHttpRequest().getServletPath())) {
                return this.toReturn;
            }
            return null;
        }

        public Collection<ConfigAttribute> getAllConfigAttributes() {
            if (!this.provideIterator) {
                return null;
            }
            return this.toReturn;
        }

        public boolean supports(Class<?> clazz) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockChannelDecisionManager
    implements ChannelDecisionManager {
        private String supportAttribute;
        private boolean commitAResponse;

        public MockChannelDecisionManager(boolean commitAResponse, String supportAttribute) {
            this.commitAResponse = commitAResponse;
            this.supportAttribute = supportAttribute;
        }

        public void decide(FilterInvocation invocation, Collection<ConfigAttribute> config) throws IOException, ServletException {
            if (this.commitAResponse) {
                invocation.getHttpResponse().sendRedirect("/redirected");
            }
        }

        public boolean supports(ConfigAttribute attribute) {
            return attribute.getAttribute().equals(this.supportAttribute);
        }
    }
}

