/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;

public class InsecureChannelProcessorTests
extends TestCase {
    public void testDecideDetectsAcceptableChannel() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/bigapp");
        request.setServletPath("/servlet");
        request.setScheme("http");
        request.setServerPort(8080);
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.decide(fi, (Collection)SecurityConfig.createList((String[])new String[]{"SOME_IGNORED_ATTRIBUTE", "REQUIRES_INSECURE_CHANNEL"}));
        InsecureChannelProcessorTests.assertFalse((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideDetectsUnacceptableChannel() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/bigapp");
        request.setServletPath("/servlet");
        request.setScheme("https");
        request.setSecure(true);
        request.setServerPort(8443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.decide(fi, (Collection)SecurityConfig.createList((String[])new String[]{"SOME_IGNORED_ATTRIBUTE", "REQUIRES_INSECURE_CHANNEL"}));
        InsecureChannelProcessorTests.assertTrue((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideRejectsNulls() throws Exception {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.afterPropertiesSet();
        try {
            processor.decide(null, null);
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        InsecureChannelProcessorTests.assertEquals((String)"REQUIRES_INSECURE_CHANNEL", (String)processor.getInsecureKeyword());
        processor.setInsecureKeyword("X");
        InsecureChannelProcessorTests.assertEquals((String)"X", (String)processor.getInsecureKeyword());
        InsecureChannelProcessorTests.assertTrue((processor.getEntryPoint() != null ? 1 : 0) != 0);
        processor.setEntryPoint(null);
        InsecureChannelProcessorTests.assertTrue((processor.getEntryPoint() == null ? 1 : 0) != 0);
    }

    public void testMissingEntryPoint() throws Exception {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.setEntryPoint(null);
        try {
            processor.afterPropertiesSet();
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertEquals((String)"entryPoint required", (String)expected.getMessage());
        }
    }

    public void testMissingSecureChannelKeyword() throws Exception {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.setInsecureKeyword(null);
        try {
            processor.afterPropertiesSet();
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertEquals((String)"insecureKeyword required", (String)expected.getMessage());
        }
        processor.setInsecureKeyword("");
        try {
            processor.afterPropertiesSet();
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertEquals((String)"insecureKeyword required", (String)expected.getMessage());
        }
    }

    public void testSupports() {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        InsecureChannelProcessorTests.assertTrue((boolean)processor.supports((ConfigAttribute)new SecurityConfig("REQUIRES_INSECURE_CHANNEL")));
        InsecureChannelProcessorTests.assertFalse((boolean)processor.supports(null));
        InsecureChannelProcessorTests.assertFalse((boolean)processor.supports((ConfigAttribute)new SecurityConfig("NOT_SUPPORTED")));
    }
}

