/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.channel;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockPortResolver;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;

public class RetryWithHttpsEntryPointTests
extends TestCase {
    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingPortMapper() throws Exception {
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        try {
            ep.setPortMapper(null);
            RetryWithHttpsEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        try {
            ep.setPortResolver(null);
            RetryWithHttpsEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGettersSetters() {
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        RetryWithHttpsEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        RetryWithHttpsEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/bigWebApp/hello/pathInfo.html");
        request.setQueryString("open=true");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }

    public void testNormalOperationWithNullQueryString() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/bigWebApp/hello");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenTargetPortIsUnknown() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/bigWebApp");
        request.setQueryString("open=true");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setServerPort(8768);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8768, 1234));
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"/bigWebApp?open=true", (String)response.getRedirectedUrl());
    }

    public void testOperationWithNonStandardPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/bigWebApp/hello/pathInfo.html");
        request.setQueryString("open=true");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        RetryWithHttpsEntryPoint ep = new RetryWithHttpsEntryPoint();
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.setPortMapper((PortMapper)portMapper);
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response);
        RetryWithHttpsEntryPointTests.assertEquals((String)"https://www.example.com:9999/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }
}

