/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class WebSecurityExpressionRootTests {
    @Test
    public void ipAddressMatchesForEqualIpAddresses() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test");
        request.setRemoteAddr("192.168.1.1");
        WebSecurityExpressionRoot root = new WebSecurityExpressionRoot((Authentication)Mockito.mock(Authentication.class), new FilterInvocation((ServletRequest)request, (ServletResponse)Mockito.mock(HttpServletResponse.class), (FilterChain)Mockito.mock(FilterChain.class)));
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.1"));
        request.setRemoteAddr("fa:db8:85a3::8a2e:370:7334");
        Assert.assertTrue((boolean)root.hasIpAddress("fa:db8:85a3::8a2e:370:7334"));
    }

    @Test
    public void addressesInIpRangeMatch() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test");
        WebSecurityExpressionRoot root = new WebSecurityExpressionRoot((Authentication)Mockito.mock(Authentication.class), new FilterInvocation((ServletRequest)request, (ServletResponse)Mockito.mock(HttpServletResponse.class), (FilterChain)Mockito.mock(FilterChain.class)));
        for (int i = 0; i < 255; ++i) {
            request.setRemoteAddr("192.168.1." + i);
            Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.0/24"));
        }
        request.setRemoteAddr("192.168.1.127");
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.0/25"));
        request.setRemoteAddr("192.168.1.128");
        Assert.assertFalse((boolean)root.hasIpAddress("192.168.1.0/25"));
        request.setRemoteAddr("192.168.1.255");
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.128/25"));
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.192/26"));
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.224/27"));
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.240/27"));
        Assert.assertTrue((boolean)root.hasIpAddress("192.168.1.255/32"));
        request.setRemoteAddr("202.24.199.127");
        Assert.assertTrue((boolean)root.hasIpAddress("202.24.0.0/14"));
        request.setRemoteAddr("202.25.179.135");
        Assert.assertTrue((boolean)root.hasIpAddress("202.24.0.0/14"));
        request.setRemoteAddr("202.26.179.135");
        Assert.assertTrue((boolean)root.hasIpAddress("202.24.0.0/14"));
    }
}

