/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;

public class DefaultFilterInvocationSecurityMetadataSourceTests {
    private DefaultFilterInvocationSecurityMetadataSource fids;
    private Collection<ConfigAttribute> def = SecurityConfig.createList((String[])new String[]{"ROLE_ONE"});

    private void createFids(String url, String method) {
        LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestKey, Collection<ConfigAttribute>>();
        requestMap.put(new RequestKey(url, method), this.def);
        this.fids = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)new AntUrlPathMatcher(), requestMap);
        this.fids.setStripQueryStringFromUrls(true);
    }

    private void createFids(String url, boolean convertToLowerCase) {
        LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestKey, Collection<ConfigAttribute>>();
        requestMap.put(new RequestKey(url), this.def);
        this.fids = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)new AntUrlPathMatcher(convertToLowerCase), requestMap);
        this.fids.setStripQueryStringFromUrls(true);
    }

    @Test
    public void convertUrlToLowercaseIsTrueByDefault() {
        LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestKey, Collection<ConfigAttribute>>();
        requestMap.put(new RequestKey("/something"), this.def);
        this.fids = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)new AntUrlPathMatcher(), requestMap);
        Assert.assertTrue((boolean)this.fids.isConvertUrlToLowercaseBeforeComparison());
    }

    @Test
    public void lookupNotRequiringExactMatchSucceedsIfNotMatching() {
        this.createFids("/secure/super/**", null);
        FilterInvocation fi = this.createFilterInvocation("/SeCuRE/super/somefile.html", null);
        Assert.assertEquals(this.def, (Object)this.fids.lookupAttributes(fi.getRequestUrl(), null));
    }

    @Test
    public void lookupNotRequiringExactMatchSucceedsIfSecureUrlPathContainsUpperCase() {
        this.createFids("/SeCuRE/super/**", null);
        FilterInvocation fi = this.createFilterInvocation("/secure/super/somefile.html", null);
        Collection response = this.fids.lookupAttributes(fi.getRequestUrl(), null);
        Assert.assertEquals(this.def, (Object)response);
    }

    @Test
    public void lookupRequiringExactMatchFailsIfNotMatching() {
        this.createFids("/secure/super/**", false);
        FilterInvocation fi = this.createFilterInvocation("/SeCuRE/super/somefile.html", null);
        Collection response = this.fids.lookupAttributes(fi.getRequestUrl(), null);
        Assert.assertEquals(null, (Object)response);
    }

    @Test
    public void lookupRequiringExactMatchIsSuccessful() {
        this.createFids("/SeCurE/super/**", false);
        FilterInvocation fi = this.createFilterInvocation("/SeCurE/super/somefile.html", null);
        Collection response = this.fids.lookupAttributes(fi.getRequestUrl(), null);
        Assert.assertEquals(this.def, (Object)response);
    }

    @Test
    public void lookupRequiringExactMatchWithAdditionalSlashesIsSuccessful() {
        this.createFids("/someAdminPage.html**", null);
        FilterInvocation fi = this.createFilterInvocation("/someAdminPage.html?a=/test", null);
        Collection response = this.fids.lookupAttributes(fi.getRequestUrl(), null);
        Assert.assertEquals(this.def, (Object)response);
    }

    @Test(expected=IllegalArgumentException.class)
    public void unknownHttpMethodIsRejected() {
        this.createFids("/someAdminPage.html**", "UNKNOWN");
    }

    @Test
    public void httpMethodLookupSucceeds() {
        this.createFids("/somepage**", "GET");
        FilterInvocation fi = this.createFilterInvocation("/somepage", "GET");
        Collection attrs = this.fids.getAttributes((Object)fi);
        Assert.assertEquals(this.def, (Object)attrs);
    }

    @Test
    public void generalMatchIsUsedIfNoMethodSpecificMatchExists() {
        this.createFids("/somepage**", null);
        FilterInvocation fi = this.createFilterInvocation("/somepage", "GET");
        Collection attrs = this.fids.getAttributes((Object)fi);
        Assert.assertEquals(this.def, (Object)attrs);
    }

    @Test
    public void requestWithDifferentHttpMethodDoesntMatch() {
        this.createFids("/somepage**", "GET");
        FilterInvocation fi = this.createFilterInvocation("/somepage", null);
        Collection attrs = this.fids.getAttributes((Object)fi);
        Assert.assertNull((Object)attrs);
    }

    @Test
    public void httpMethodSpecificUrlTakesPrecedence() {
        LinkedHashMap<RequestKey, Collection<ConfigAttribute>> requestMap = new LinkedHashMap<RequestKey, Collection<ConfigAttribute>>();
        requestMap.put(new RequestKey("/**"), this.def);
        List postOnlyDef = SecurityConfig.createList((String[])new String[]{"ROLE_TWO"});
        requestMap.put(new RequestKey("/somepage**", "POST"), postOnlyDef);
        this.fids = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)new AntUrlPathMatcher(), requestMap);
        Collection attrs = this.fids.getAttributes((Object)this.createFilterInvocation("/somepage", "POST"));
        Assert.assertEquals((Object)postOnlyDef, (Object)attrs);
    }

    @Test
    public void mixingPatternsWithAndWithoutHttpMethodsIsSupported() throws Exception {
        LinkedHashMap<RequestKey, List> requestMap = new LinkedHashMap<RequestKey, List>();
        List userAttrs = SecurityConfig.createList((String[])new String[]{"A"});
        requestMap.put(new RequestKey("/user/**", null), userAttrs);
        requestMap.put(new RequestKey("/teller/**", "GET"), SecurityConfig.createList((String[])new String[]{"B"}));
        this.fids = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)new AntUrlPathMatcher(), requestMap);
        this.fids.setStripQueryStringFromUrls(true);
        FilterInvocation fi = this.createFilterInvocation("/user", "GET");
        Collection attrs = this.fids.getAttributes((Object)fi);
        Assert.assertEquals((Object)userAttrs, (Object)attrs);
    }

    @Test
    public void methodSpecificMatchTakesPrecdenceRegardlessOfOrdering() throws Exception {
        LinkedHashMap<RequestKey, List> requestMap = new LinkedHashMap<RequestKey, List>();
        List userAttrs = SecurityConfig.createList((String[])new String[]{"A"});
        requestMap.put(new RequestKey("/secure/specific.html", null), SecurityConfig.createList((String[])new String[]{"B"}));
        requestMap.put(new RequestKey("/secure/*.html", "GET"), userAttrs);
        this.fids = new DefaultFilterInvocationSecurityMetadataSource((UrlMatcher)new AntUrlPathMatcher(), requestMap);
        this.fids.setStripQueryStringFromUrls(true);
        FilterInvocation fi = this.createFilterInvocation("/secure/specific.html", "GET");
        Collection attrs = this.fids.getAttributes((Object)fi);
        Assert.assertEquals((Object)userAttrs, (Object)attrs);
    }

    @Test
    public void extraQuestionMarkStillMatches() {
        this.createFids("/someAdminPage.html*", null);
        FilterInvocation fi = this.createFilterInvocation("/someAdminPage.html?x=2/aa?y=3", null);
        Collection response = this.fids.lookupAttributes(fi.getRequestUrl(), null);
        Assert.assertEquals(this.def, (Object)response);
        fi = this.createFilterInvocation("/someAdminPage.html??", null);
        response = this.fids.lookupAttributes(fi.getRequestUrl(), null);
        Assert.assertEquals(this.def, (Object)response);
    }

    private FilterInvocation createFilterInvocation(String path, String method) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        request.setMethod(method);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)Mockito.mock(FilterChain.class));
    }
}

