/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.FilterInvocation;

public class FilterInvocationTests {
    @Test
    public void testGettersAndStringMethods() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        request.setServletPath("/HelloWorld");
        request.setPathInfo("/some/more/segments.html");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld/some/more/segments.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertEquals((Object)request, (Object)fi.getRequest());
        Assert.assertEquals((Object)request, (Object)fi.getHttpRequest());
        Assert.assertEquals((Object)response, (Object)fi.getResponse());
        Assert.assertEquals((Object)response, (Object)fi.getHttpResponse());
        Assert.assertEquals((Object)chain, (Object)fi.getChain());
        Assert.assertEquals((Object)"/HelloWorld/some/more/segments.html", (Object)fi.getRequestUrl());
        Assert.assertEquals((Object)"FilterInvocation: URL: /HelloWorld/some/more/segments.html", (Object)fi.toString());
        Assert.assertEquals((Object)"http://www.example.com/mycontext/HelloWorld/some/more/segments.html", (Object)fi.getFullRequestUrl());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNullFilterChain() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        new FilterInvocation((ServletRequest)request, (ServletResponse)response, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNullServletRequest() {
        MockHttpServletResponse response = new MockHttpServletResponse();
        new FilterInvocation(null, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRejectsNullServletResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        new FilterInvocation((ServletRequest)request, null, (FilterChain)Mockito.mock(FilterChain.class));
    }

    @Test
    public void testStringMethodsWithAQueryString() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("foo=bar");
        request.setServletPath("/HelloWorld");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld");
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        Assert.assertEquals((Object)"/HelloWorld?foo=bar", (Object)fi.getRequestUrl());
        Assert.assertEquals((Object)"FilterInvocation: URL: /HelloWorld?foo=bar", (Object)fi.toString());
        Assert.assertEquals((Object)"http://www.example.com/mycontext/HelloWorld?foo=bar", (Object)fi.getFullRequestUrl());
    }

    @Test
    public void testStringMethodsWithoutAnyQueryString() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        request.setServletPath("/HelloWorld");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld");
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)Mockito.mock(FilterChain.class));
        Assert.assertEquals((Object)"/HelloWorld", (Object)fi.getRequestUrl());
        Assert.assertEquals((Object)"FilterInvocation: URL: /HelloWorld", (Object)fi.toString());
        Assert.assertEquals((Object)"http://www.example.com/mycontext/HelloWorld", (Object)fi.getFullRequestUrl());
    }
}

