/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.access.intercept.RunAsManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;

public class FilterSecurityInterceptorTests {
    private Mockery jmock = new JUnit4Mockery();
    private AuthenticationManager am;
    private AccessDecisionManager adm;
    private FilterInvocationSecurityMetadataSource ods;
    private RunAsManager ram;
    private FilterSecurityInterceptor interceptor;
    private ApplicationEventPublisher publisher;

    @Before
    public final void setUp() throws Exception {
        this.interceptor = new FilterSecurityInterceptor();
        this.am = (AuthenticationManager)this.jmock.mock(AuthenticationManager.class);
        this.ods = (FilterInvocationSecurityMetadataSource)this.jmock.mock(FilterInvocationSecurityMetadataSource.class);
        this.adm = (AccessDecisionManager)this.jmock.mock(AccessDecisionManager.class);
        this.ram = (RunAsManager)this.jmock.mock(RunAsManager.class);
        this.publisher = (ApplicationEventPublisher)this.jmock.mock(ApplicationEventPublisher.class);
        this.interceptor.setAuthenticationManager(this.am);
        this.interceptor.setSecurityMetadataSource(this.ods);
        this.interceptor.setAccessDecisionManager(this.adm);
        this.interceptor.setRunAsManager(this.ram);
        this.interceptor.setApplicationEventPublisher(this.publisher);
        SecurityContextHolder.clearContext();
    }

    @After
    public void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnsuresAccessDecisionManagerSupportsFilterInvocationClass() throws Exception {
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(FilterSecurityInterceptorTests.this.ods);
                ((AccessDecisionManager)this.allowing(FilterSecurityInterceptorTests.this.adm)).supports(FilterInvocation.class);
                this.will(1.returnValue((Object)false));
            }
        });
        this.interceptor.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnsuresRunAsManagerSupportsFilterInvocationClass() throws Exception {
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(FilterSecurityInterceptorTests.this.ods);
                ((RunAsManager)this.allowing(FilterSecurityInterceptorTests.this.ram)).supports(FilterInvocation.class);
                this.will(2.returnValue((Object)false));
            }
        });
        this.interceptor.afterPropertiesSet();
    }

    @Test
    public void testSuccessfulInvocation() throws Throwable {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new String[]{"NOT_USED"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        FilterChain chain = (FilterChain)this.jmock.mock(FilterChain.class);
        final FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, chain);
        final List attributes = SecurityConfig.createList((String[])new String[]{"MOCK_OK"});
        this.jmock.checking((ExpectationBuilder)new Expectations((Authentication)token, chain, request, response){
            final /* synthetic */ Authentication val$token;
            final /* synthetic */ FilterChain val$chain;
            final /* synthetic */ MockHttpServletRequest val$request;
            final /* synthetic */ MockHttpServletResponse val$response;
            {
                this.val$token = authentication;
                this.val$chain = filterChain;
                this.val$request = mockHttpServletRequest;
                this.val$response = mockHttpServletResponse;
                this.ignoring(FilterSecurityInterceptorTests.this.ram);
                ((FilterInvocationSecurityMetadataSource)this.allowing(FilterSecurityInterceptorTests.this.ods)).getAttributes((Object)fi);
                this.will(3.returnValue((Object)attributes));
                ((AccessDecisionManager)this.oneOf(FilterSecurityInterceptorTests.this.adm)).decide(this.val$token, (Object)fi, (Collection)attributes);
                ((FilterChain)this.oneOf(this.val$chain)).doFilter((ServletRequest)this.val$request, (ServletResponse)this.val$response);
                ((ApplicationEventPublisher)this.oneOf(FilterSecurityInterceptorTests.this.publisher)).publishEvent((ApplicationEvent)this.with(3.aNonNull(AuthorizedEvent.class)));
            }
        });
        this.interceptor.invoke(fi);
    }
}

