/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.intercept;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.web.access.intercept.RequestKey;

public class RequestKeyTests {
    @Test
    public void equalsWorksWithNullHttpMethod() {
        RequestKey key1 = new RequestKey("/someurl");
        RequestKey key2 = new RequestKey("/someurl");
        Assert.assertEquals((Object)key1, (Object)key2);
        key1 = new RequestKey("/someurl", "GET");
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertFalse((boolean)key2.equals((Object)key1));
    }

    @Test
    public void keysWithSameUrlAndHttpMethodAreEqual() {
        RequestKey key1 = new RequestKey("/someurl", "GET");
        RequestKey key2 = new RequestKey("/someurl", "GET");
        Assert.assertEquals((Object)key1, (Object)key2);
    }

    @Test
    public void keysWithSameUrlAndDifferentHttpMethodAreNotEqual() {
        RequestKey key1 = new RequestKey("/someurl", "GET");
        RequestKey key2 = new RequestKey("/someurl", "POST");
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertFalse((boolean)key2.equals((Object)key1));
    }

    @Test
    public void keysWithDifferentUrlsAreNotEquals() {
        RequestKey key1 = new RequestKey("/someurl", "GET");
        RequestKey key2 = new RequestKey("/anotherurl", "GET");
        Assert.assertFalse((boolean)key1.equals((Object)key2));
        Assert.assertFalse((boolean)key2.equals((Object)key1));
    }
}

