/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.ExceptionMappingAuthenticationFailureHandler;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class AbstractAuthenticationProcessingFilterTests
extends TestCase {
    SavedRequestAwareAuthenticationSuccessHandler successHandler;
    SimpleUrlAuthenticationFailureHandler failureHandler;

    private MockHttpServletRequest createMockRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/j_mock_post");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/j_mock_post");
        request.setContextPath("/mycontext");
        return request;
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    private DefaultSavedRequest makeSavedRequestForUrl() {
        MockHttpServletRequest request = this.createMockRequest();
        request.setMethod("GET");
        request.setServletPath("/some_protected_file.html");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/some_protected_file.html");
        return new DefaultSavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        this.successHandler.setDefaultTargetUrl("/logged_in.jsp");
        this.failureHandler = new SimpleUrlAuthenticationFailureHandler();
        this.failureHandler.setDefaultFailureUrl("/failed.jsp");
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDefaultProcessesFilterUrlMatchesWithPathParameter() {
        MockHttpServletRequest request = this.createMockRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter();
        filter.setFilterProcessesUrl("/j_spring_security_check");
        request.setRequestURI("/mycontext/j_spring_security_check;jsessionid=I8MIONOSTHOR");
        AbstractAuthenticationProcessingFilterTests.assertTrue((boolean)filter.requiresAuthentication((HttpServletRequest)request, (HttpServletResponse)response));
    }

    public void testFailedAuthenticationRedirectsAppropriately() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(false);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/failed.jsp", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        filter = new MockAuthenticationFilter((AuthenticationException)new AccountExpiredException("You're account is expired"));
        ExceptionMappingAuthenticationFailureHandler failureHandler = new ExceptionMappingAuthenticationFailureHandler();
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)failureHandler);
        Properties exceptionMappings = new Properties();
        exceptionMappings.setProperty(AccountExpiredException.class.getName(), "/accountExpired.jsp");
        failureHandler.setExceptionMappings((Map)exceptionMappings);
        response = new MockHttpServletResponse();
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/accountExpired.jsp", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testFilterProcessesUrlVariationsRespected() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/j_OTHER_LOCATION");
        request.setRequestURI("/mycontext/j_OTHER_LOCATION");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        filter.setFilterProcessesUrl("/j_OTHER_LOCATION");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
    }

    public void testGettersSetters() throws Exception {
        MockAuthenticationFilter filter = new MockAuthenticationFilter();
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.setFilterProcessesUrl("/p");
        filter.afterPropertiesSet();
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)filter.getRememberMeServices());
        filter.setRememberMeServices((RememberMeServices)new TokenBasedRememberMeServices());
        AbstractAuthenticationProcessingFilterTests.assertEquals(TokenBasedRememberMeServices.class, filter.getRememberMeServices().getClass());
        AbstractAuthenticationProcessingFilterTests.assertTrue((filter.getAuthenticationManager() != null ? 1 : 0) != 0);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/p", (String)filter.getFilterProcessesUrl());
    }

    public void testIgnoresAnyServletPathOtherThanFilterProcessesUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/some.file.html");
        request.setRequestURI("/mycontext/some.file.html");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(false);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithDefaultFilterProcessesUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        HttpSession sessionPreAuth = request.getSession();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)Mockito.mock(SessionAuthenticationStrategy.class));
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.afterPropertiesSet();
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        AbstractAuthenticationProcessingFilterTests.assertEquals((Object)sessionPreAuth, (Object)request.getSession());
    }

    public void testStartupDetectsInvalidAuthenticationManager() throws Exception {
        MockAuthenticationFilter filter = new MockAuthenticationFilter();
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        this.successHandler.setDefaultTargetUrl("/");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        filter.setFilterProcessesUrl("/j_spring_security_check");
        try {
            filter.afterPropertiesSet();
            AbstractAuthenticationProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractAuthenticationProcessingFilterTests.assertEquals((String)"authenticationManager must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsInvalidFilterProcessesUrl() throws Exception {
        MockAuthenticationFilter filter = new MockAuthenticationFilter();
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        filter.setFilterProcessesUrl(null);
        try {
            filter.afterPropertiesSet();
            AbstractAuthenticationProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractAuthenticationProcessingFilterTests.assertEquals((String)"filterProcessesUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testSuccessLoginThenFailureLoginResultsInSessionLosingToken() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        chain = new MockFilterChain(false);
        response = new MockHttpServletResponse();
        filter = new MockAuthenticationFilter(false);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationButWithAlwaysUseDefaultTargetUrlCausesRedirectToDefaultTargetUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)this.makeSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        this.successHandler.setDefaultTargetUrl("/foobar");
        this.successHandler.setAlwaysUseDefaultTargetUrl(true);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/foobar", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationCausesRedirectToSessionSpecifiedUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)this.makeSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)this.makeSavedRequestForUrl().getRedirectUrl(), (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testFullDefaultTargetUrlDoesNotHaveContextPathPrepended() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        this.successHandler.setDefaultTargetUrl("https://monkeymachine.co.uk/");
        this.successHandler.setAlwaysUseDefaultTargetUrl(true);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"https://monkeymachine.co.uk/", (String)response.getRedirectedUrl());
        AbstractAuthenticationProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testNoSessionIsCreatedIfAllowSessionCreationIsFalse() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(false);
        filter.setAllowSessionCreation(false);
        this.failureHandler.setAllowSessionCreation(false);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        this.successHandler.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertNull((Object)request.getSession(false));
    }

    public void testLoginErrorWithNoFailureUrlSendsUnauthorizedStatus() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(false);
        this.successHandler.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testServerSideRedirectForwardsToFailureUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(false);
        this.successHandler.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        this.failureHandler.setUseForward(true);
        this.failureHandler.setDefaultFailureUrl("/error");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/error", (String)response.getForwardedUrl());
    }

    public void testTargetUrlParameterIsUsedIfPresent() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setParameter("targetUrl", "/target");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAuthenticationFilter filter = new MockAuthenticationFilter(true);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successHandler);
        this.successHandler.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        this.successHandler.setTargetUrlParameter("targetUrl");
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.failureHandler);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractAuthenticationProcessingFilterTests.assertEquals((String)"/mycontext/target", (String)response.getRedirectedUrl());
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }

    private class MockAuthenticationFilter
    extends AbstractAuthenticationProcessingFilter {
        private AuthenticationException exceptionToThrow;
        private boolean grantAccess;

        public MockAuthenticationFilter(boolean grantAccess) {
            this();
            this.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
            this.grantAccess = grantAccess;
            this.exceptionToThrow = new BadCredentialsException("Mock requested to do so");
        }

        public MockAuthenticationFilter(AuthenticationException exceptionToThrow) {
            this();
            this.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
            this.grantAccess = false;
            this.exceptionToThrow = exceptionToThrow;
        }

        private MockAuthenticationFilter() {
            super("/j_mock_post");
        }

        public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
            if (this.grantAccess) {
                return new UsernamePasswordAuthenticationToken((Object)"test", (Object)"test", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"TEST"}));
            }
            throw this.exceptionToThrow;
        }

        public boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
            return super.requiresAuthentication(request, response);
        }
    }
}

