/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.memory.UserAttribute;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class AnonymousAuthenticationFilterTests {
    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.doFilter(request, response, filterChain);
    }

    @Before
    @After
    public void clearContext() throws Exception {
        SecurityContextHolder.clearContext();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsMissingKey() throws Exception {
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousAuthenticationFilter filter = new AnonymousAuthenticationFilter();
        filter.setUserAttribute(user);
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDetectsUserAttribute() throws Exception {
        AnonymousAuthenticationFilter filter = new AnonymousAuthenticationFilter();
        filter.setKey("qwerty");
        filter.afterPropertiesSet();
    }

    @Test
    public void testGettersSetters() throws Exception {
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousAuthenticationFilter filter = new AnonymousAuthenticationFilter();
        filter.setKey("qwerty");
        filter.setUserAttribute(user);
        filter.afterPropertiesSet();
        Assert.assertEquals((Object)"qwerty", (Object)filter.getKey());
        Assert.assertEquals((Object)user, (Object)filter.getUserAttribute());
    }

    @Test
    public void testOperationWhenAuthenticationExistsInContextHolder() throws Exception {
        TestingAuthenticationToken originalAuth = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)originalAuth);
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousAuthenticationFilter filter = new AnonymousAuthenticationFilter();
        filter.setKey("qwerty");
        filter.setUserAttribute(user);
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator((FilterConfig)Mockito.mock(FilterConfig.class), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        Assert.assertEquals((Object)originalAuth, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testOperationWhenNoAuthenticationInSecurityContextHolder() throws Exception {
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousAuthenticationFilter filter = new AnonymousAuthenticationFilter();
        filter.setKey("qwerty");
        filter.setUserAttribute(user);
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator((FilterConfig)Mockito.mock(FilterConfig.class), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Assert.assertEquals((Object)"anonymousUsername", (Object)auth.getPrincipal());
        Assert.assertTrue((boolean)AuthorityUtils.authorityListToSet((Collection)auth.getAuthorities()).contains("ROLE_ANONYMOUS"));
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (!this.expectToProceed) {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

