/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;

public class DefaultLoginPageGeneratingFilterTests {
    FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);

    @Test
    public void generatingPageWithAuthenticationProcessingFilterOnlyIsSuccessFul() throws Exception {
        DefaultLoginPageGeneratingFilter filter = new DefaultLoginPageGeneratingFilter((AbstractAuthenticationProcessingFilter)new UsernamePasswordAuthenticationFilter());
        filter.doFilter((ServletRequest)new MockHttpServletRequest("GET", "/spring_security_login"), (ServletResponse)new MockHttpServletResponse(), this.chain);
        filter.doFilter((ServletRequest)new MockHttpServletRequest("GET", "/spring_security_login;pathparam=unused"), (ServletResponse)new MockHttpServletResponse(), this.chain);
    }

    @Test
    public void generatingPageWithOpenIdFilterOnlyIsSuccessFul() throws Exception {
        DefaultLoginPageGeneratingFilter filter = new DefaultLoginPageGeneratingFilter((AbstractAuthenticationProcessingFilter)new MockProcessingFilter());
        filter.doFilter((ServletRequest)new MockHttpServletRequest("GET", "/spring_security_login"), (ServletResponse)new MockHttpServletResponse(), this.chain);
    }

    @Test
    public void handlesNonIso8859CharsInErrorMessage() throws Exception {
        DefaultLoginPageGeneratingFilter filter = new DefaultLoginPageGeneratingFilter((AbstractAuthenticationProcessingFilter)new UsernamePasswordAuthenticationFilter());
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/spring_security_login");
        request.addParameter("login_error", "true");
        MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
        String message = messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials", Locale.KOREA);
        System.out.println("Message: " + message);
        request.getSession().setAttribute("SPRING_SECURITY_LAST_EXCEPTION", (Object)new BadCredentialsException(message));
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), this.chain);
    }

    private static class MockProcessingFilter
    extends AbstractAuthenticationProcessingFilter {
        protected MockProcessingFilter() {
            super("/someurl");
        }

        public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
            return null;
        }

        public String getClaimedIdentityFieldName() {
            return "unused";
        }
    }
}

