/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/springframework/security/web/authentication/DelegatingAuthenticationEntryPointTest-context.xml"})
public class DelegatingAuthenticationEntryPointContextTest {
    @Autowired
    private DelegatingAuthenticationEntryPoint daep;
    @Autowired
    @Qualifier(value="firstAEP")
    private AuthenticationEntryPoint firstAEP;
    @Autowired
    @Qualifier(value="defaultAEP")
    private AuthenticationEntryPoint defaultAEP;

    @Test
    @DirtiesContext
    public void testFirstAEP() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("192.168.1.10");
        request.addHeader("User-Agent", (Object)"Mozilla/5.0");
        this.daep.commence((HttpServletRequest)request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.firstAEP)).commence((HttpServletRequest)request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.defaultAEP, (VerificationMode)Mockito.never())).commence((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class), (AuthenticationException)Mockito.any(AuthenticationException.class));
    }

    @Test
    @DirtiesContext
    public void testDefaultAEP() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("192.168.1.10");
        this.daep.commence((HttpServletRequest)request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.defaultAEP)).commence((HttpServletRequest)request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.firstAEP, (VerificationMode)Mockito.never())).commence((HttpServletRequest)Mockito.any(HttpServletRequest.class), (HttpServletResponse)Mockito.any(HttpServletResponse.class), (AuthenticationException)Mockito.any(AuthenticationException.class));
    }
}

