/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.util.RequestMatcher;

public class DelegatingAuthenticationEntryPointTest {
    private DelegatingAuthenticationEntryPoint daep;
    private LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints;
    private AuthenticationEntryPoint defaultEntryPoint;
    private HttpServletRequest request = new MockHttpServletRequest();

    @Before
    public void before() {
        this.defaultEntryPoint = (AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class);
        this.entryPoints = new LinkedHashMap();
        this.daep = new DelegatingAuthenticationEntryPoint(this.entryPoints);
        this.daep.setDefaultEntryPoint(this.defaultEntryPoint);
    }

    @Test
    public void testDefaultEntryPoint() throws Exception {
        AuthenticationEntryPoint firstAEP = (AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class);
        RequestMatcher firstRM = (RequestMatcher)Mockito.mock(RequestMatcher.class);
        Mockito.when((Object)firstRM.matches(this.request)).thenReturn((Object)false);
        this.entryPoints.put(firstRM, firstAEP);
        this.daep.commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.defaultEntryPoint)).commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)firstAEP, (VerificationMode)Mockito.never())).commence(this.request, null, null);
    }

    @Test
    public void testFirstEntryPoint() throws Exception {
        AuthenticationEntryPoint firstAEP = (AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class);
        RequestMatcher firstRM = (RequestMatcher)Mockito.mock(RequestMatcher.class);
        AuthenticationEntryPoint secondAEP = (AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class);
        RequestMatcher secondRM = (RequestMatcher)Mockito.mock(RequestMatcher.class);
        Mockito.when((Object)firstRM.matches(this.request)).thenReturn((Object)true);
        this.entryPoints.put(firstRM, firstAEP);
        this.entryPoints.put(secondRM, secondAEP);
        this.daep.commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)firstAEP)).commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)secondAEP, (VerificationMode)Mockito.never())).commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.defaultEntryPoint, (VerificationMode)Mockito.never())).commence(this.request, null, null);
        ((RequestMatcher)Mockito.verify((Object)secondRM, (VerificationMode)Mockito.never())).matches(this.request);
    }

    @Test
    public void testSecondEntryPoint() throws Exception {
        AuthenticationEntryPoint firstAEP = (AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class);
        RequestMatcher firstRM = (RequestMatcher)Mockito.mock(RequestMatcher.class);
        AuthenticationEntryPoint secondAEP = (AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class);
        RequestMatcher secondRM = (RequestMatcher)Mockito.mock(RequestMatcher.class);
        Mockito.when((Object)firstRM.matches(this.request)).thenReturn((Object)false);
        Mockito.when((Object)secondRM.matches(this.request)).thenReturn((Object)true);
        this.entryPoints.put(firstRM, firstAEP);
        this.entryPoints.put(secondRM, secondAEP);
        this.daep.commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)secondAEP)).commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)firstAEP, (VerificationMode)Mockito.never())).commence(this.request, null, null);
        ((AuthenticationEntryPoint)Mockito.verify((Object)this.defaultEntryPoint, (VerificationMode)Mockito.never())).commence(this.request, null, null);
    }
}

