/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockPortResolver;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class LoginUrlAuthenticationEntryPointTests
extends TestCase {
    public void testDetectsMissingLoginFormUrl() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        try {
            ep.afterPropertiesSet();
            LoginUrlAuthenticationEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDetectsMissingPortMapper() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("xxx");
        ep.setPortMapper(null);
        try {
            ep.afterPropertiesSet();
            LoginUrlAuthenticationEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("xxx");
        ep.setPortResolver(null);
        try {
            ep.afterPropertiesSet();
            LoginUrlAuthenticationEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGettersSetters() {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"/hello", (String)ep.getLoginFormUrl());
        LoginUrlAuthenticationEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        LoginUrlAuthenticationEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
        ep.setForceHttps(false);
        LoginUrlAuthenticationEntryPointTests.assertFalse((boolean)ep.isForceHttps());
        ep.setForceHttps(true);
        LoginUrlAuthenticationEntryPointTests.assertTrue((boolean)ep.isForceHttps());
    }

    public void testHttpsOperationFromOriginalHttpUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8080);
        response = new MockHttpServletResponse();
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8888);
        response = new MockHttpServletResponse();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        response = new MockHttpServletResponse();
        ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)portMapper);
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.afterPropertiesSet();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com:9999/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testHttpsOperationFromOriginalHttpsUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8443);
        response = new MockHttpServletResponse();
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testNormalOperation() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenHttpsRequestsButHttpsPortUnknown() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 1234));
        ep.setForceHttps(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"http://www.example.com:8888/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testServerSideRedirectWithoutForceHttpsForwardsToLoginPage() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setUseForward(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/bigWebApp/some_path");
        request.setServletPath("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"/hello", (String)response.getForwardedUrl());
    }

    public void testServerSideRedirectWithForceHttpsRedirectsCurrentRequest() throws Exception {
        LoginUrlAuthenticationEntryPoint ep = new LoginUrlAuthenticationEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setUseForward(true);
        ep.setForceHttps(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/bigWebApp/some_path");
        request.setServletPath("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, null);
        LoginUrlAuthenticationEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/some_path", (String)response.getRedirectedUrl());
    }
}

