/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class UsernamePasswordAuthenticationFilterTests
extends TestCase {
    @Test
    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/");
        request.addParameter("j_username", "rod");
        request.addParameter("j_password", "koala");
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        UsernamePasswordAuthenticationFilterTests.assertEquals((String)"/j_spring_security_check", (String)filter.getFilterProcessesUrl());
        filter.setAuthenticationManager(this.createAuthenticationManager());
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        UsernamePasswordAuthenticationFilterTests.assertTrue((result != null ? 1 : 0) != 0);
        UsernamePasswordAuthenticationFilterTests.assertEquals((Object)"rod", (Object)request.getSession().getAttribute("SPRING_SECURITY_LAST_USERNAME"));
        UsernamePasswordAuthenticationFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    @Test
    public void testNullPasswordHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/");
        request.addParameter("j_username", "rod");
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        UsernamePasswordAuthenticationFilterTests.assertNotNull((Object)filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
    }

    @Test
    public void testNullUsernameHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/");
        request.addParameter("j_password", "koala");
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        UsernamePasswordAuthenticationFilterTests.assertNotNull((Object)filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse()));
    }

    @Test
    public void testUsingDifferentParameterNamesWorksAsExpected() throws ServletException {
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.setUsernameParameter("x");
        filter.setPasswordParameter("y");
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/");
        request.addParameter("x", "rod");
        request.addParameter("y", "koala");
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        UsernamePasswordAuthenticationFilterTests.assertNotNull((Object)result);
        UsernamePasswordAuthenticationFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    @Test
    public void testSpacesAreTrimmedCorrectlyFromUsername() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/");
        request.addParameter("j_username", " rod ");
        request.addParameter("j_password", "koala");
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        UsernamePasswordAuthenticationFilterTests.assertEquals((String)"rod", (String)result.getName());
    }

    @Test
    public void testFailedAuthenticationThrowsException() {
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/");
        request.addParameter("j_username", "rod");
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenThrow(new Throwable[]{new BadCredentialsException("")});
        filter.setAuthenticationManager(am);
        try {
            filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            UsernamePasswordAuthenticationFilterTests.fail((String)"Expected AuthenticationException");
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        UsernamePasswordAuthenticationFilterTests.assertEquals((Object)"rod", (Object)request.getSession().getAttribute("SPRING_SECURITY_LAST_USERNAME"));
    }

    @Test
    public void noSessionIsCreatedIfAllowSessionCreationIsFalse() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        UsernamePasswordAuthenticationFilter filter = new UsernamePasswordAuthenticationFilter();
        filter.setAllowSessionCreation(false);
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.attemptAuthentication((HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        UsernamePasswordAuthenticationFilterTests.assertNull((Object)request.getSession(false));
    }

    private AuthenticationManager createAuthenticationManager() {
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenAnswer((Answer)new Answer<Authentication>(){

            public Authentication answer(InvocationOnMock invocation) throws Throwable {
                return (Authentication)invocation.getArguments()[0];
            }
        });
        return am;
    }
}

