/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class AbstractPreAuthenticatedProcessingFilterTests {
    private AbstractPreAuthenticatedProcessingFilter filter;

    @Before
    public void createFilter() {
        this.filter = new AbstractPreAuthenticatedProcessingFilter(){

            protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
                return "n/a";
            }

            protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
                return "doesntmatter";
            }
        };
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void filterChainProceedsOnFailedAuthenticationByDefault() throws Exception {
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenThrow(new Throwable[]{new BadCredentialsException("")});
        this.filter.setAuthenticationManager(am);
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)Mockito.mock(FilterChain.class));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test(expected=BadCredentialsException.class)
    public void exceptionIsThrownOnFailedAuthenticationIfContinueFilterChainOnUnsuccessfulAuthenticationSetToFalse() throws Exception {
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenThrow(new Throwable[]{new BadCredentialsException("")});
        this.filter.setContinueFilterChainOnUnsuccessfulAuthentication(false);
        this.filter.setAuthenticationManager(am);
        this.filter.afterPropertiesSet();
        this.filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)Mockito.mock(FilterChain.class));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testAfterPropertiesSet() {
        ConcretePreAuthenticatedProcessingFilter filter = new ConcretePreAuthenticatedProcessingFilter();
        try {
            filter.afterPropertiesSet();
            Assert.fail((String)"AfterPropertiesSet didn't throw expected exception");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            Assert.fail((String)"AfterPropertiesSet throws unexpected exception");
        }
    }

    @Test
    public void testDoFilterAuthenticated() throws Exception {
        this.testDoFilter(true);
    }

    @Test
    public void testDoFilterUnauthenticated() throws Exception {
        this.testDoFilter(false);
    }

    private void testDoFilter(boolean grantAccess) throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        AbstractPreAuthenticatedProcessingFilterTests.getFilter(grantAccess).doFilter((ServletRequest)req, (ServletResponse)res, (FilterChain)new MockFilterChain());
        Assert.assertEquals((Object)grantAccess, (Object)(null != SecurityContextHolder.getContext().getAuthentication() ? 1 : 0));
    }

    private static ConcretePreAuthenticatedProcessingFilter getFilter(boolean grantAccess) throws Exception {
        ConcretePreAuthenticatedProcessingFilter filter = new ConcretePreAuthenticatedProcessingFilter();
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        if (!grantAccess) {
            Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenThrow(new Throwable[]{new BadCredentialsException("")});
        } else {
            Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenAnswer((Answer)new Answer<Authentication>(){

                public Authentication answer(InvocationOnMock invocation) throws Throwable {
                    return (Authentication)invocation.getArguments()[0];
                }
            });
        }
        filter.setAuthenticationManager(am);
        filter.afterPropertiesSet();
        return filter;
    }

    private static class ConcretePreAuthenticatedProcessingFilter
    extends AbstractPreAuthenticatedProcessingFilter {
        private ConcretePreAuthenticatedProcessingFilter() {
        }

        protected Object getPreAuthenticatedPrincipal(HttpServletRequest httpRequest) {
            return "testPrincipal";
        }

        protected Object getPreAuthenticatedCredentials(HttpServletRequest httpRequest) {
            return "testCredentials";
        }
    }
}

