/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class PreAuthenticatedAuthenticationTokenTests
extends TestCase {
    public void testPreAuthenticatedAuthenticationTokenRequestWithDetails() {
        String principal = "dummyUser";
        String credentials = "dummyCredentials";
        String details = "dummyDetails";
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials);
        token.setDetails((Object)details);
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)principal, (Object)token.getPrincipal());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)credentials, (Object)token.getCredentials());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)details, (Object)token.getDetails());
        PreAuthenticatedAuthenticationTokenTests.assertTrue((boolean)token.getAuthorities().isEmpty());
    }

    public void testPreAuthenticatedAuthenticationTokenRequestWithoutDetails() {
        String principal = "dummyUser";
        String credentials = "dummyCredentials";
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials);
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)principal, (Object)token.getPrincipal());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)credentials, (Object)token.getCredentials());
        PreAuthenticatedAuthenticationTokenTests.assertNull((Object)token.getDetails());
        PreAuthenticatedAuthenticationTokenTests.assertTrue((boolean)token.getAuthorities().isEmpty());
    }

    public void testPreAuthenticatedAuthenticationTokenResponse() {
        String principal = "dummyUser";
        String credentials = "dummyCredentials";
        List gas = AuthorityUtils.createAuthorityList((String[])new String[]{"Role1"});
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)credentials, (Collection)gas);
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)principal, (Object)token.getPrincipal());
        PreAuthenticatedAuthenticationTokenTests.assertEquals((Object)credentials, (Object)token.getCredentials());
        PreAuthenticatedAuthenticationTokenTests.assertNull((Object)token.getDetails());
        PreAuthenticatedAuthenticationTokenTests.assertNotNull((Object)token.getAuthorities());
        Collection resultColl = token.getAuthorities();
        PreAuthenticatedAuthenticationTokenTests.assertTrue((String)("GrantedAuthority collections do not match; result: " + resultColl + ", expected: " + gas), (gas.containsAll(resultColl) && resultColl.containsAll(gas) ? 1 : 0) != 0);
    }
}

