/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthoritiesContainer;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreAuthenticatedGrantedAuthoritiesUserDetailsServiceTests {
    @Test(expected=IllegalArgumentException.class)
    public void testGetUserDetailsInvalidType() {
        PreAuthenticatedGrantedAuthoritiesUserDetailsService svc = new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)"dummy", (Object)"dummy");
        token.setDetails(new Object());
        svc.loadUserDetails((Authentication)token);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetUserDetailsNoDetails() {
        PreAuthenticatedGrantedAuthoritiesUserDetailsService svc = new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)"dummy", (Object)"dummy");
        token.setDetails(null);
        svc.loadUserDetails((Authentication)token);
    }

    @Test
    public void testGetUserDetailsEmptyAuthorities() {
        String userName = "dummyUser";
        this.testGetUserDetails("dummyUser", AuthorityUtils.NO_AUTHORITIES);
    }

    @Test
    public void testGetUserDetailsWithAuthorities() {
        String userName = "dummyUser";
        this.testGetUserDetails("dummyUser", AuthorityUtils.createAuthorityList((String[])new String[]{"Role1", "Role2"}));
    }

    private void testGetUserDetails(String userName, final List<GrantedAuthority> gas) {
        PreAuthenticatedGrantedAuthoritiesUserDetailsService svc = new PreAuthenticatedGrantedAuthoritiesUserDetailsService();
        PreAuthenticatedAuthenticationToken token = new PreAuthenticatedAuthenticationToken((Object)userName, (Object)"dummy");
        token.setDetails((Object)new GrantedAuthoritiesContainer(){

            public List<GrantedAuthority> getGrantedAuthorities() {
                return gas;
            }
        });
        UserDetails ud = svc.loadUserDetails((Authentication)token);
        Assert.assertTrue((boolean)ud.isAccountNonExpired());
        Assert.assertTrue((boolean)ud.isAccountNonLocked());
        Assert.assertTrue((boolean)ud.isCredentialsNonExpired());
        Assert.assertTrue((boolean)ud.isEnabled());
        Assert.assertEquals((Object)ud.getUsername(), (Object)userName);
        Assert.assertTrue((String)("GrantedAuthority collections do not match; result: " + ud.getAuthorities() + ", expected: " + gas), (gas.containsAll(ud.getAuthorities()) && ud.getAuthorities().containsAll(gas) ? 1 : 0) != 0);
    }
}

