/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;

public class PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetailsTests {
    List<GrantedAuthority> gas = AuthorityUtils.createAuthorityList((String[])new String[]{"Role1", "Role2"});

    @Test
    public void testToString() {
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(this.getRequest("testUser", new String[0]));
        details.setGrantedAuthorities(this.gas);
        String toString = details.toString();
        Assert.assertTrue((String)"toString should contain Role1", (boolean)toString.contains("Role1"));
        Assert.assertTrue((String)"toString should contain Role2", (boolean)toString.contains("Role2"));
    }

    @Test
    public void testGetSetPreAuthenticatedGrantedAuthorities() {
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(this.getRequest("testUser", new String[0]));
        details.setGrantedAuthorities(this.gas);
        List returnedGas = details.getGrantedAuthorities();
        Assert.assertTrue((String)("Collections do not contain same elements; expected: " + this.gas + ", returned: " + returnedGas), (this.gas.containsAll(returnedGas) && returnedGas.containsAll(this.gas) ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithoutSetPreAuthenticatedGrantedAuthorities() {
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(this.getRequest("testUser", new String[0]));
        details.getGrantedAuthorities();
    }

    private HttpServletRequest getRequest(String userName, final String[] aRoles) {
        MockHttpServletRequest req = new MockHttpServletRequest(){
            private Set<String> roles;
            {
                this.roles = new HashSet<String>(Arrays.asList(aRoles));
            }

            public boolean isUserInRole(String arg0) {
                return this.roles.contains(arg0);
            }
        };
        req.setRemoteUser(userName);
        return req;
    }
}

