/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.header;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;

public class RequestHeaderAuthenticationFilterTests {
    @After
    @Before
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test(expected=PreAuthenticatedCredentialsNotFoundException.class)
    public void rejectsMissingHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void defaultsToUsingSiteminderHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("SM_USER", (Object)"cat");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"cat", (Object)SecurityContextHolder.getContext().getAuthentication().getName());
        Assert.assertEquals((Object)"N/A", (Object)SecurityContextHolder.getContext().getAuthentication().getCredentials());
    }

    @Test
    public void alternativeHeaderNameIsSupported() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("myUsernameHeader", (Object)"wolfman");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.setPrincipalRequestHeader("myUsernameHeader");
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"wolfman", (Object)SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @Test
    public void credentialsAreRetrievedIfHeaderNameIsSet() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.setCredentialsRequestHeader("myCredentialsHeader");
        request.addHeader("SM_USER", (Object)"cat");
        request.addHeader("myCredentialsHeader", (Object)"catspassword");
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"catspassword", (Object)SecurityContextHolder.getContext().getAuthentication().getCredentials());
    }

    @Test
    public void userIsReauthenticatedIfPrincipalChangesAndCheckForPrincipalChangesIsSet() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.setCheckForPrincipalChanges(true);
        request.addHeader("SM_USER", (Object)"cat");
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        request = new MockHttpServletRequest();
        request.addHeader("SM_USER", (Object)"dog");
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Authentication dog = SecurityContextHolder.getContext().getAuthentication();
        Assert.assertNotNull((Object)dog);
        Assert.assertEquals((Object)"dog", (Object)dog.getName());
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertSame((Object)dog, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test(expected=PreAuthenticatedCredentialsNotFoundException.class)
    public void missingHeaderCausesException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void missingHeaderIsIgnoredIfExceptionIfHeaderMissingIsFalse() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        RequestHeaderAuthenticationFilter filter = new RequestHeaderAuthenticationFilter();
        filter.setExceptionIfHeaderMissing(false);
        filter.setAuthenticationManager(this.createAuthenticationManager());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    private AuthenticationManager createAuthenticationManager() {
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenAnswer((Answer)new Answer<Authentication>(){

            public Authentication answer(InvocationOnMock invocation) throws Throwable {
                return (Authentication)invocation.getArguments()[0];
            }
        });
        return am;
    }
}

