/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.j2ee;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.MappableAttributesRetriever;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleMappableAttributesRetriever;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;
import org.springframework.security.web.authentication.preauth.j2ee.J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource;

public class J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests
extends TestCase {
    public final void testAfterPropertiesSetException() {
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource t = new J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource();
        try {
            t.afterPropertiesSet();
            J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.fail((String)"AfterPropertiesSet didn't throw expected exception");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.fail((String)"AfterPropertiesSet throws unexpected exception");
        }
    }

    public final void testBuildDetailsHttpServletRequestNoMappedNoUserRoles() {
        String[] mappedRoles = new String[]{};
        String[] roles = new String[]{};
        String[] expectedRoles = new String[]{};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    public final void testBuildDetailsHttpServletRequestNoMappedUnmappedUserRoles() {
        String[] mappedRoles = new String[]{};
        String[] roles = new String[]{"Role1", "Role2"};
        String[] expectedRoles = new String[]{};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    public final void testBuildDetailsHttpServletRequestNoUserRoles() {
        String[] mappedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        String[] roles = new String[]{};
        String[] expectedRoles = new String[]{};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    public final void testBuildDetailsHttpServletRequestAllUserRoles() {
        String[] mappedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        String[] roles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        String[] expectedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    public final void testBuildDetailsHttpServletRequestUnmappedUserRoles() {
        String[] mappedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        String[] roles = new String[]{"Role1", "Role2", "Role3", "Role4", "Role5"};
        String[] expectedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    public final void testBuildDetailsHttpServletRequestPartialUserRoles() {
        String[] mappedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        String[] roles = new String[]{"Role2", "Role3"};
        String[] expectedRoles = new String[]{"Role2", "Role3"};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    public final void testBuildDetailsHttpServletRequestPartialAndUnmappedUserRoles() {
        String[] mappedRoles = new String[]{"Role1", "Role2", "Role3", "Role4"};
        String[] roles = new String[]{"Role2", "Role3", "Role5"};
        String[] expectedRoles = new String[]{"Role2", "Role3"};
        this.testDetails(mappedRoles, roles, expectedRoles);
    }

    private void testDetails(String[] mappedRoles, String[] userRoles, String[] expectedRoles) {
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource src = this.getJ2eeBasedPreAuthenticatedWebAuthenticationDetailsSource(mappedRoles);
        Object o = src.buildDetails((Object)this.getRequest("testUser", userRoles));
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.assertNotNull((Object)o);
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.assertTrue((String)("Returned object not of type PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails, actual type: " + o.getClass()), (boolean)(o instanceof PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails));
        PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails details = (PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails)o;
        List gas = details.getGrantedAuthorities();
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.assertNotNull((String)"Granted authorities should not be null", (Object)gas);
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.assertEquals((int)expectedRoles.length, (int)gas.size());
        List<String> expectedRolesColl = Arrays.asList(expectedRoles);
        HashSet<String> gasRolesSet = new HashSet<String>();
        for (int i = 0; i < gas.size(); ++i) {
            gasRolesSet.add(((GrantedAuthority)gas.get(i)).getAuthority());
        }
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.assertTrue((String)"Granted Authorities do not match expected roles", (expectedRolesColl.containsAll(gasRolesSet) && gasRolesSet.containsAll(expectedRolesColl) ? 1 : 0) != 0);
    }

    private final J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource getJ2eeBasedPreAuthenticatedWebAuthenticationDetailsSource(String[] mappedRoles) {
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource result = new J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource();
        result.setMappableRolesRetriever(this.getMappableRolesRetriever(mappedRoles));
        result.setUserRoles2GrantedAuthoritiesMapper(this.getJ2eeUserRoles2GrantedAuthoritiesMapper());
        result.setClazz(PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails.class);
        try {
            result.afterPropertiesSet();
        }
        catch (Exception expected) {
            J2eeBasedPreAuthenticatedWebAuthenticationDetailsSourceTests.fail((String)"AfterPropertiesSet throws unexpected exception");
        }
        return result;
    }

    private MappableAttributesRetriever getMappableRolesRetriever(String[] mappedRoles) {
        SimpleMappableAttributesRetriever result = new SimpleMappableAttributesRetriever();
        result.setMappableAttributes(new HashSet<String>(Arrays.asList(mappedRoles)));
        return result;
    }

    private Attributes2GrantedAuthoritiesMapper getJ2eeUserRoles2GrantedAuthoritiesMapper() {
        SimpleAttributes2GrantedAuthoritiesMapper result = new SimpleAttributes2GrantedAuthoritiesMapper();
        result.setAddPrefixIfAlreadyExisting(false);
        result.setConvertAttributeToLowerCase(false);
        result.setConvertAttributeToUpperCase(false);
        result.setAttributePrefix("");
        return result;
    }

    private final HttpServletRequest getRequest(String userName, final String[] aRoles) {
        MockHttpServletRequest req = new MockHttpServletRequest(){
            private Set<String> roles;
            {
                this.roles = new HashSet<String>(Arrays.asList(aRoles));
            }

            public boolean isUserInRole(String arg0) {
                return this.roles.contains(arg0);
            }
        };
        req.setRemoteUser(userName);
        return req;
    }
}

