/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.j2ee;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.web.authentication.preauth.j2ee.WebXmlMappableAttributesRetriever;

public class WebXmlJ2eeDefinedRolesRetrieverTests {
    @Test
    public void testRole1To4Roles() throws Exception {
        List<String> ROLE1TO4_EXPECTED_ROLES = Arrays.asList("Role1", "Role2", "Role3", "Role4");
        ClassPathResource webXml = new ClassPathResource("webxml/Role1-4.web.xml");
        WebXmlMappableAttributesRetriever rolesRetriever = new WebXmlMappableAttributesRetriever();
        rolesRetriever.setResourceLoader(new ResourceLoader((Resource)webXml){
            final /* synthetic */ Resource val$webXml;
            {
                this.val$webXml = resource;
            }

            public ClassLoader getClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public Resource getResource(String location) {
                return this.val$webXml;
            }
        });
        rolesRetriever.afterPropertiesSet();
        Set j2eeRoles = rolesRetriever.getMappableAttributes();
        Assert.assertNotNull((Object)j2eeRoles);
        Assert.assertTrue((String)("J2eeRoles expected size: " + ROLE1TO4_EXPECTED_ROLES.size() + ", actual size: " + j2eeRoles.size()), (j2eeRoles.size() == ROLE1TO4_EXPECTED_ROLES.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)("J2eeRoles expected contents (arbitrary order): " + ROLE1TO4_EXPECTED_ROLES + ", actual content: " + j2eeRoles), (boolean)j2eeRoles.containsAll(ROLE1TO4_EXPECTED_ROLES));
    }

    @Test
    public void testGetZeroJ2eeRoles() throws Exception {
        ClassPathResource webXml = new ClassPathResource("webxml/NoRoles.web.xml");
        WebXmlMappableAttributesRetriever rolesRetriever = new WebXmlMappableAttributesRetriever();
        rolesRetriever.setResourceLoader(new ResourceLoader((Resource)webXml){
            final /* synthetic */ Resource val$webXml;
            {
                this.val$webXml = resource;
            }

            public ClassLoader getClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public Resource getResource(String location) {
                return this.val$webXml;
            }
        });
        rolesRetriever.afterPropertiesSet();
        Set j2eeRoles = rolesRetriever.getMappableAttributes();
        Assert.assertEquals((String)("J2eeRoles expected size: 0, actual size: " + j2eeRoles.size()), (long)0L, (long)j2eeRoles.size());
    }
}

