/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.websphere;

import org.aopalliance.intercept.MethodInvocation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.websphere.WASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WebSphere2SpringSecurityPropagationInterceptor;

public class WebSphere2SpringSecurityPropagationInterceptorTests {
    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void createdAuthenticationTokenIsAcceptableToPreauthProvider() throws Throwable {
        WASUsernameAndGroupsExtractor helper = (WASUsernameAndGroupsExtractor)Mockito.mock(WASUsernameAndGroupsExtractor.class);
        Mockito.when((Object)helper.getCurrentUserName()).thenReturn((Object)"joe");
        WebSphere2SpringSecurityPropagationInterceptor interceptor = new WebSphere2SpringSecurityPropagationInterceptor(helper);
        SecurityContextImpl context = new SecurityContextImpl();
        interceptor.setAuthenticationManager(new AuthenticationManager((SecurityContext)context){
            final /* synthetic */ SecurityContext val$context;
            {
                this.val$context = securityContext;
            }

            public Authentication authenticate(Authentication authentication) {
                this.val$context.setAuthentication(authentication);
                return null;
            }
        });
        interceptor.setAuthenticationDetailsSource((AuthenticationDetailsSource)Mockito.mock(AuthenticationDetailsSource.class));
        interceptor.invoke((MethodInvocation)Mockito.mock(MethodInvocation.class));
        PreAuthenticatedAuthenticationProvider provider = new PreAuthenticatedAuthenticationProvider();
        AuthenticationUserDetailsService uds = (AuthenticationUserDetailsService)Mockito.mock(AuthenticationUserDetailsService.class);
        UserDetails user = (UserDetails)Mockito.mock(UserDetails.class);
        Mockito.when((Object)user.getAuthorities()).thenReturn((Object)AuthorityUtils.createAuthorityList((String[])new String[]{"SOME_ROLE"}));
        Mockito.when((Object)uds.loadUserDetails((Authentication)Mockito.any(Authentication.class))).thenReturn((Object)user);
        provider.setPreAuthenticatedUserDetailsService(uds);
        provider.setUserDetailsChecker((UserDetailsChecker)Mockito.mock(UserDetailsChecker.class));
        Assert.assertNotNull((Object)provider.authenticate(context.getAuthentication()));
    }
}

