/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.util.Collection;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.StringUtils;

public class AbstractRememberMeServicesTests {
    static User joe = new User("joe", "password", true, true, true, true, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_A"}));

    @Test(expected=InvalidCookieException.class)
    public void nonBase64CookieShouldBeDetected() {
        new MockRememberMeServices().decodeCookie("nonBase64CookieValue%");
    }

    @Test
    public void setAndGetAreConsistent() throws Exception {
        MockRememberMeServices services = new MockRememberMeServices();
        Assert.assertNotNull((Object)services.getCookieName());
        Assert.assertNotNull((Object)services.getParameter());
        services.setKey("xxxx");
        Assert.assertEquals((Object)"xxxx", (Object)services.getKey());
        services.setParameter("rm");
        Assert.assertEquals((Object)"rm", (Object)services.getParameter());
        services.setCookieName("kookie");
        Assert.assertEquals((Object)"kookie", (Object)services.getCookieName());
        services.setTokenValiditySeconds(600);
        Assert.assertEquals((long)600L, (long)services.getTokenValiditySeconds());
        UserDetailsService uds = (UserDetailsService)Mockito.mock(UserDetailsService.class);
        services.setUserDetailsService(uds);
        Assert.assertSame((Object)uds, (Object)services.getUserDetailsService());
        AuthenticationDetailsSource ads = (AuthenticationDetailsSource)Mockito.mock(AuthenticationDetailsSource.class);
        services.setAuthenticationDetailsSource(ads);
        Assert.assertSame((Object)ads, (Object)services.getAuthenticationDetailsSource());
        services.afterPropertiesSet();
    }

    @Test
    public void cookieShouldBeCorrectlyEncodedAndDecoded() throws Exception {
        String[] cookie = new String[]{"name", "cookie", "tokens", "blah"};
        MockRememberMeServices services = new MockRememberMeServices();
        String encoded = services.encodeCookie(cookie);
        Assert.assertFalse((boolean)encoded.endsWith("="));
        String[] decoded = services.decodeCookie(encoded);
        Assert.assertEquals((long)4L, (long)decoded.length);
        Assert.assertEquals((Object)"name", (Object)decoded[0]);
        Assert.assertEquals((Object)"cookie", (Object)decoded[1]);
        Assert.assertEquals((Object)"tokens", (Object)decoded[2]);
        Assert.assertEquals((Object)"blah", (Object)decoded[3]);
    }

    @Test
    public void cookieWithOpenIDidentifierAsNameIsEncodedAndDecoded() throws Exception {
        String[] cookie = new String[]{"http://id.openid.zz", "cookie", "tokens", "blah"};
        MockRememberMeServices services = new MockRememberMeServices();
        String[] decoded = services.decodeCookie(services.encodeCookie(cookie));
        Assert.assertEquals((long)4L, (long)decoded.length);
        Assert.assertEquals((Object)"http://id.openid.zz", (Object)decoded[0]);
        cookie[0] = "https://id.openid.zz";
        decoded = services.decodeCookie(services.encodeCookie(cookie));
        Assert.assertEquals((long)4L, (long)decoded.length);
        Assert.assertEquals((Object)"https://id.openid.zz", (Object)decoded[0]);
    }

    @Test
    public void autoLoginShouldReturnNullIfNoLoginCookieIsPresented() {
        MockRememberMeServices services = new MockRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Assert.assertNull((Object)response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE"));
        request = new MockHttpServletRequest();
        response = new MockHttpServletResponse();
        request.setCookies(new Cookie[]{new Cookie("mycookie", "cookie")});
        Assert.assertNull((Object)services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Assert.assertNull((Object)response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE"));
    }

    @Test
    public void successfulAutoLoginReturnsExpectedAuthentication() throws Exception {
        MockRememberMeServices services = new MockRememberMeServices();
        services.setUserDetailsService(new MockUserDetailsService((UserDetails)joe, false));
        services.afterPropertiesSet();
        Assert.assertNotNull((Object)services.getUserDetailsService());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(this.createLoginCookie("cookie:1:2"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void autoLoginShouldFailIfCookieIsNotBase64() throws Exception {
        MockRememberMeServices services = new MockRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setCookies(new Cookie[]{new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", "ZZZ")});
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        this.assertCookieCancelled(response);
    }

    @Test
    public void autoLoginShouldFailIfCookieIsEmpty() throws Exception {
        MockRememberMeServices services = new MockRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setCookies(new Cookie[]{new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", "")});
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        this.assertCookieCancelled(response);
    }

    @Test
    public void autoLoginShouldFailIfInvalidCookieExceptionIsRaised() {
        MockRememberMeServices services = new MockRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(this.createLoginCookie("cookie:1"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        this.assertCookieCancelled(response);
    }

    @Test
    public void autoLoginShouldFailIfUserNotFound() {
        MockRememberMeServices services = new MockRememberMeServices();
        services.setUserDetailsService(new MockUserDetailsService((UserDetails)joe, true));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(this.createLoginCookie("cookie:1:2"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        this.assertCookieCancelled(response);
    }

    @Test
    public void autoLoginShouldFailIfUserAccountIsLocked() {
        MockRememberMeServices services = new MockRememberMeServices();
        User joeLocked = new User("joe", "password", false, true, true, true, joe.getAuthorities());
        services.setUserDetailsService(new MockUserDetailsService((UserDetails)joeLocked, false));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(this.createLoginCookie("cookie:1:2"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        this.assertCookieCancelled(response);
    }

    @Test
    public void loginFailShouldCancelCookie() {
        MockRememberMeServices services = new MockRememberMeServices();
        services.setUserDetailsService(new MockUserDetailsService((UserDetails)joe, true));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("contextpath");
        request.setCookies(this.createLoginCookie("cookie:1:2"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.loginFail((HttpServletRequest)request, (HttpServletResponse)response);
        this.assertCookieCancelled(response);
    }

    @Test
    public void logoutShouldCancelCookie() throws Exception {
        MockRememberMeServices services = new MockRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("contextpath");
        request.setCookies(this.createLoginCookie("cookie:1:2"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.logout((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)Mockito.mock(Authentication.class));
        response = new MockHttpServletResponse();
        services.logout((HttpServletRequest)request, (HttpServletResponse)response, null);
        this.assertCookieCancelled(response);
    }

    @Test(expected=CookieTheftException.class)
    public void cookieTheftExceptionShouldBeRethrown() {
        MockRememberMeServices services = new MockRememberMeServices(){

            protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
                throw new CookieTheftException("Pretending cookie was stolen");
            }
        };
        services.setUserDetailsService(new MockUserDetailsService((UserDetails)joe, false));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(this.createLoginCookie("cookie:1:2"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Test
    public void loginSuccessCallsOnLoginSuccessCorrectly() {
        MockRememberMeServices services = new MockRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"joe", (Object)"password");
        services = new MockRememberMeServices();
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)auth);
        Assert.assertFalse((boolean)services.loginSuccessCalled);
        services = new MockRememberMeServices();
        request.setParameter("_spring_security_remember_me", "true");
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)auth);
        Assert.assertTrue((boolean)services.loginSuccessCalled);
        services = new MockRememberMeServices();
        services.setParameter("my_parameter");
        request.setParameter("my_parameter", "true");
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)auth);
        Assert.assertTrue((boolean)services.loginSuccessCalled);
        services = new MockRememberMeServices();
        request.setParameter("_spring_security_remember_me", "false");
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)auth);
        Assert.assertFalse((boolean)services.loginSuccessCalled);
        services = new MockRememberMeServices();
        services.setAlwaysRemember(true);
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)auth);
        Assert.assertTrue((boolean)services.loginSuccessCalled);
    }

    @Test
    public void setCookieUsesCorrectNamePathAndValue() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContextPath("contextpath");
        MockRememberMeServices services = new MockRememberMeServices(){

            protected String encodeCookie(String[] cookieTokens) {
                return cookieTokens[0];
            }
        };
        services.setCookieName("mycookiename");
        services.setCookie(new String[]{"mycookie"}, 1000, (HttpServletRequest)request, (HttpServletResponse)response);
        Cookie cookie = response.getCookie("mycookiename");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((Object)"mycookie", (Object)cookie.getValue());
        Assert.assertEquals((Object)"mycookiename", (Object)cookie.getName());
        Assert.assertEquals((Object)"contextpath", (Object)cookie.getPath());
        Assert.assertFalse((boolean)cookie.getSecure());
    }

    @Test
    public void setCookieSetsSecureFlagIfConfigured() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setContextPath("contextpath");
        MockRememberMeServices services = new MockRememberMeServices(){

            protected String encodeCookie(String[] cookieTokens) {
                return cookieTokens[0];
            }
        };
        services.setUseSecureCookie(true);
        services.setCookie(new String[]{"mycookie"}, 1000, (HttpServletRequest)request, (HttpServletResponse)response);
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertTrue((boolean)cookie.getSecure());
    }

    private Cookie[] createLoginCookie(String cookieToken) {
        MockRememberMeServices services = new MockRememberMeServices();
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", services.encodeCookie(StringUtils.delimitedListToStringArray((String)cookieToken, (String)":")));
        return new Cookie[]{cookie};
    }

    private void assertCookieCancelled(MockHttpServletResponse response) {
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    public static class MockUserDetailsService
    implements UserDetailsService {
        private UserDetails toReturn;
        private boolean throwException;

        public MockUserDetailsService(UserDetails toReturn, boolean throwException) {
            this.toReturn = toReturn;
            this.throwException = throwException;
        }

        public UserDetails loadUserByUsername(String username) {
            if (this.throwException) {
                throw new UsernameNotFoundException("as requested by mock");
            }
            return this.toReturn;
        }
    }

    private class MockRememberMeServices
    extends AbstractRememberMeServices {
        boolean loginSuccessCalled;

        private MockRememberMeServices() {
            this.setKey("key");
        }

        protected void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
            this.loginSuccessCalled = true;
        }

        protected UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) throws RememberMeAuthenticationException {
            if (cookieTokens.length != 3) {
                throw new InvalidCookieException("deliberate exception");
            }
            UserDetails user = this.getUserDetailsService().loadUserByUsername("joe");
            return user;
        }
    }
}

