/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServicesTests;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;

public class PersistentTokenBasedRememberMeServicesTests {
    private PersistentTokenBasedRememberMeServices services;

    @Before
    public void setUpData() throws Exception {
        this.services = new PersistentTokenBasedRememberMeServices();
        this.services.setCookieName("mycookiename");
        this.services.setTokenValiditySeconds(8640000);
        this.services.setUserDetailsService((UserDetailsService)new AbstractRememberMeServicesTests.MockUserDetailsService((UserDetails)AbstractRememberMeServicesTests.joe, false));
    }

    @Test(expected=InvalidCookieException.class)
    public void loginIsRejectedWithWrongNumberOfCookieTokens() {
        this.services.processAutoLoginCookie(new String[]{"series", "token", "extra"}, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
    }

    @Test(expected=RememberMeAuthenticationException.class)
    public void loginIsRejectedWhenNoTokenMatchingSeriesIsFound() {
        this.services.setTokenRepository((PersistentTokenRepository)new MockTokenRepository(null));
        this.services.processAutoLoginCookie(new String[]{"series", "token"}, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
    }

    @Test(expected=RememberMeAuthenticationException.class)
    public void loginIsRejectedWhenTokenIsExpired() {
        MockTokenRepository repo = new MockTokenRepository(new PersistentRememberMeToken("joe", "series", "token", new Date()));
        this.services.setTokenRepository((PersistentTokenRepository)repo);
        this.services.setTokenValiditySeconds(1);
        try {
            Thread.sleep(1100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.services.setTokenRepository((PersistentTokenRepository)repo);
        this.services.processAutoLoginCookie(new String[]{"series", "token"}, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
    }

    @Test(expected=CookieTheftException.class)
    public void cookieTheftIsDetectedWhenSeriesAndTokenDontMatch() {
        PersistentRememberMeToken token = new PersistentRememberMeToken("joe", "series", "wrongtoken", new Date());
        this.services.setTokenRepository((PersistentTokenRepository)new MockTokenRepository(token));
        this.services.processAutoLoginCookie(new String[]{"series", "token"}, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
    }

    @Test
    public void successfulAutoLoginCreatesNewTokenAndCookieWithSameSeries() {
        MockTokenRepository repo = new MockTokenRepository(new PersistentRememberMeToken("joe", "series", "token", new Date()));
        this.services.setTokenRepository((PersistentTokenRepository)repo);
        this.services.setTokenLength(12);
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.services.processAutoLoginCookie(new String[]{"series", "token"}, (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        Assert.assertEquals((Object)"series", (Object)repo.getStoredToken().getSeries());
        Assert.assertEquals((long)16L, (long)repo.getStoredToken().getTokenValue().length());
        String[] cookie = this.services.decodeCookie(response.getCookie("mycookiename").getValue());
        Assert.assertEquals((Object)"series", (Object)cookie[0]);
        Assert.assertEquals((Object)repo.getStoredToken().getTokenValue(), (Object)cookie[1]);
    }

    @Test
    public void loginSuccessCreatesNewTokenAndCookieWithNewSeries() {
        this.services.setAlwaysRemember(true);
        MockTokenRepository repo = new MockTokenRepository(null);
        this.services.setTokenRepository((PersistentTokenRepository)repo);
        this.services.setTokenLength(12);
        this.services.setSeriesLength(12);
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.services.loginSuccess((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response, (Authentication)new UsernamePasswordAuthenticationToken((Object)"joe", (Object)"password"));
        Assert.assertEquals((long)16L, (long)repo.getStoredToken().getSeries().length());
        Assert.assertEquals((long)16L, (long)repo.getStoredToken().getTokenValue().length());
        String[] cookie = this.services.decodeCookie(response.getCookie("mycookiename").getValue());
        Assert.assertEquals((Object)repo.getStoredToken().getSeries(), (Object)cookie[0]);
        Assert.assertEquals((Object)repo.getStoredToken().getTokenValue(), (Object)cookie[1]);
    }

    @Test
    public void logoutClearsUsersTokenAndCookie() throws Exception {
        Cookie cookie = new Cookie("mycookiename", "somevalue");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockTokenRepository repo = new MockTokenRepository(new PersistentRememberMeToken("joe", "series", "token", new Date()));
        this.services.setTokenRepository((PersistentTokenRepository)repo);
        this.services.logout((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"joe", (Object)"somepass", new String[]{"SOME_AUTH"}));
        Cookie returnedCookie = response.getCookie("mycookiename");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
        this.services.logout((HttpServletRequest)request, (HttpServletResponse)response, null);
    }

    private class MockTokenRepository
    implements PersistentTokenRepository {
        private PersistentRememberMeToken storedToken;

        private MockTokenRepository(PersistentRememberMeToken token) {
            this.storedToken = token;
        }

        public void createNewToken(PersistentRememberMeToken token) {
            this.storedToken = token;
        }

        public void updateToken(String series, String tokenValue, Date lastUsed) {
            this.storedToken = new PersistentRememberMeToken(this.storedToken.getUsername(), this.storedToken.getSeries(), tokenValue, lastUsed);
        }

        public PersistentRememberMeToken getTokenForSeries(String seriesId) {
            return this.storedToken;
        }

        public void removeUserTokens(String username) {
        }

        PersistentRememberMeToken getStoredToken() {
            return this.storedToken;
        }
    }
}

