/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;

public class RememberMeAuthenticationFilterTests
extends TestCase {
    Authentication remembered = new TestingAuthenticationToken((Object)"remembered", (Object)"password", new String[]{"ROLE_REMEMBERED"});

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.doFilter(request, response, filterChain);
    }

    protected void setUp() throws Exception {
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testDetectsAuthenticationManagerProperty() throws Exception {
        RememberMeAuthenticationFilter filter = new RememberMeAuthenticationFilter();
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.setRememberMeServices((RememberMeServices)new NullRememberMeServices());
        filter.afterPropertiesSet();
        filter.setAuthenticationManager(null);
        try {
            filter.afterPropertiesSet();
            RememberMeAuthenticationFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationFilterTests.assertTrue((boolean)true);
        }
    }

    public void testDetectsRememberMeServicesProperty() throws Exception {
        RememberMeAuthenticationFilter filter = new RememberMeAuthenticationFilter();
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.setRememberMeServices((RememberMeServices)new TokenBasedRememberMeServices());
        RememberMeAuthenticationFilterTests.assertEquals(TokenBasedRememberMeServices.class, filter.getRememberMeServices().getClass());
        filter.setRememberMeServices(null);
        try {
            filter.afterPropertiesSet();
            RememberMeAuthenticationFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationFilterTests.assertTrue((boolean)true);
        }
    }

    public void testOperationWhenAuthenticationExistsInContextHolder() throws Exception {
        TestingAuthenticationToken originalAuth = new TestingAuthenticationToken((Object)"user", (Object)"password", new String[]{"ROLE_A"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)originalAuth);
        RememberMeAuthenticationFilter filter = new RememberMeAuthenticationFilter();
        filter.setAuthenticationManager((AuthenticationManager)Mockito.mock(AuthenticationManager.class));
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices(this.remembered));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator((FilterConfig)Mockito.mock(FilterConfig.class), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeAuthenticationFilterTests.assertEquals((Object)originalAuth, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testOperationWhenNoAuthenticationInContextHolder() throws Exception {
        RememberMeAuthenticationFilter filter = new RememberMeAuthenticationFilter();
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate(this.remembered)).thenReturn((Object)this.remembered);
        filter.setAuthenticationManager(am);
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices(this.remembered));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator((FilterConfig)Mockito.mock(FilterConfig.class), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeAuthenticationFilterTests.assertEquals((Object)this.remembered, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testOnUnsuccessfulLoginIsCalledWhenProviderRejectsAuth() throws Exception {
        TestingAuthenticationToken failedAuth = new TestingAuthenticationToken((Object)"failed", (Object)"");
        RememberMeAuthenticationFilter filter = new RememberMeAuthenticationFilter((Authentication)failedAuth){
            final /* synthetic */ Authentication val$failedAuth;
            {
                this.val$failedAuth = authentication;
            }

            protected void onUnsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) {
                super.onUnsuccessfulAuthentication(request, response, failed);
                SecurityContextHolder.getContext().setAuthentication(this.val$failedAuth);
            }
        };
        AuthenticationManager am = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)am.authenticate((Authentication)Matchers.any(Authentication.class))).thenThrow(new Throwable[]{new BadCredentialsException("")});
        filter.setAuthenticationManager(am);
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices(this.remembered));
        filter.setApplicationEventPublisher((ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator((FilterConfig)Mockito.mock(FilterConfig.class), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeAuthenticationFilterTests.assertEquals((Object)failedAuth, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    private class MockRememberMeServices
    implements RememberMeServices {
        private Authentication authToReturn;

        public MockRememberMeServices(Authentication authToReturn) {
            this.authToReturn = authToReturn;
        }

        public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
            return this.authToReturn;
        }

        public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        }

        public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

