/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.rememberme;

import java.util.Collection;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.util.StringUtils;

public class TokenBasedRememberMeServicesTests {
    private Mockery jmock = new JUnit4Mockery();
    private UserDetailsService uds;
    private UserDetails user = new User("someone", "password", true, true, true, true, (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ABC"}));
    private TokenBasedRememberMeServices services;
    private Expectations udsWillReturnUser;
    private Expectations udsWillThrowNotFound;

    @Before
    public void createTokenBasedRememberMeServices() {
        this.services = new TokenBasedRememberMeServices();
        this.uds = (UserDetailsService)this.jmock.mock(UserDetailsService.class);
        this.services.setKey("key");
        this.services.setUserDetailsService(this.uds);
        this.udsWillReturnUser = new Expectations(){
            {
                ((UserDetailsService)this.oneOf(TokenBasedRememberMeServicesTests.this.uds)).loadUserByUsername((String)this.with(1.aNonNull(String.class)));
                this.will(1.returnValue((Object)TokenBasedRememberMeServicesTests.this.user));
            }
        };
        this.udsWillThrowNotFound = new Expectations(){
            {
                ((UserDetailsService)this.oneOf(TokenBasedRememberMeServicesTests.this.uds)).loadUserByUsername((String)this.with(2.aNonNull(String.class)));
                this.will(2.throwException((Throwable)new UsernameNotFoundException("")));
            }
        };
    }

    private long determineExpiryTimeFromBased64EncodedToken(String validToken) {
        String cookieAsPlainText = new String(Base64.decodeBase64((byte[])validToken.getBytes()));
        String[] cookieTokens = StringUtils.delimitedListToStringArray((String)cookieAsPlainText, (String)":");
        if (cookieTokens.length == 3) {
            try {
                return new Long(cookieTokens[1]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return -1L;
    }

    private String generateCorrectCookieContentForToken(long expiryTime, String username, String password, String key) {
        String signatureValue = new String(DigestUtils.md5Hex((String)(username + ":" + expiryTime + ":" + password + ":" + key)));
        String tokenValue = username + ":" + expiryTime + ":" + signatureValue;
        String tokenValueBase64 = new String(Base64.encodeBase64((byte[])tokenValue.getBytes()));
        return tokenValueBase64;
    }

    @Test
    public void autoLoginReturnsNullIfNoCookiePresented() throws Exception {
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = this.services.autoLogin((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE"));
    }

    @Test
    public void autoLoginIgnoresUnrelatedCookie() throws Exception {
        Cookie cookie = new Cookie("unrelated_cookie", "foobar");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNull((Object)result);
        Assert.assertNull((Object)response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE"));
    }

    @Test
    public void autoLoginReturnsNullForExpiredCookieAndClearsCookie() throws Exception {
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() - 1000000L, "someone", "password", "key"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    @Test
    public void autoLoginReturnsNullAndClearsCookieIfMissingThreeTokensInCookieValue() throws Exception {
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", new String(Base64.encodeBase64((byte[])"x".getBytes())));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    @Test
    public void autoLoginClearsNonBase64EncodedCookie() throws Exception {
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", "NOT_BASE_64_ENCODED");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    @Test
    public void autoLoginClearsCookieIfSignatureBlocksDoesNotMatchExpectedValue() throws Exception {
        this.jmock.checking((ExpectationBuilder)this.udsWillReturnUser);
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() + 1000000L, "someone", "password", "WRONG_KEY"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    @Test
    public void autoLoginClearsCookieIfTokenDoesNotContainANumberInCookieValue() throws Exception {
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", new String(Base64.encodeBase64((byte[])"username:NOT_A_NUMBER:signature".getBytes())));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    @Test
    public void autoLoginClearsCookieIfUserNotFound() throws Exception {
        this.jmock.checking((ExpectationBuilder)this.udsWillThrowNotFound);
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() + 1000000L, "someone", "password", "key"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response));
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)returnedCookie);
        Assert.assertEquals((long)0L, (long)returnedCookie.getMaxAge());
    }

    @Test
    public void autoLoginWithValidTokenAndUserSucceeds() throws Exception {
        this.jmock.checking((ExpectationBuilder)this.udsWillReturnUser);
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() + 1000000L, "someone", "password", "key"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = this.services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.user, (Object)result.getPrincipal());
    }

    @Test
    public void testGettersSetters() {
        Assert.assertEquals((Object)this.uds, (Object)this.services.getUserDetailsService());
        this.services.setKey("d");
        Assert.assertEquals((Object)"d", (Object)this.services.getKey());
        Assert.assertEquals((Object)"_spring_security_remember_me", (Object)this.services.getParameter());
        this.services.setParameter("some_param");
        Assert.assertEquals((Object)"some_param", (Object)this.services.getParameter());
        this.services.setTokenValiditySeconds(12);
        Assert.assertEquals((long)12L, (long)this.services.getTokenValiditySeconds());
    }

    @Test
    public void loginFailClearsCookie() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.services.loginFail((HttpServletRequest)request, (HttpServletResponse)response);
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((long)0L, (long)cookie.getMaxAge());
    }

    @Test
    public void loginSuccessIgnoredIfParameterNotSetOrFalse() {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("_spring_security_remember_me", "false");
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"someone", (Object)"password", new String[]{"ROLE_ABC"}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNull((Object)cookie);
    }

    @Test
    public void loginSuccessNormalWithNonUserDetailsBasedPrincipalSetsExpectedCookie() {
        this.services.setTokenValiditySeconds(500000000);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("_spring_security_remember_me", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"someone", (Object)"password", new String[]{"ROLE_ABC"}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        String expiryTime = this.services.decodeCookie(cookie.getValue())[1];
        long expectedExpiryTime = 500000000000L;
        Assert.assertTrue((Long.parseLong(expiryTime) > (expectedExpiryTime += System.currentTimeMillis()) - 10000L ? 1 : 0) != 0);
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((long)this.services.getTokenValiditySeconds(), (long)cookie.getMaxAge());
        Assert.assertTrue((boolean)Base64.isArrayByteBase64((byte[])cookie.getValue().getBytes()));
        Assert.assertTrue((boolean)new Date().before(new Date(this.determineExpiryTimeFromBased64EncodedToken(cookie.getValue()))));
    }

    @Test
    public void loginSuccessNormalWithUserDetailsBasedPrincipalSetsExpectedCookie() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("_spring_security_remember_me", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"someone", (Object)"password", new String[]{"ROLE_ABC"}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((long)this.services.getTokenValiditySeconds(), (long)cookie.getMaxAge());
        Assert.assertTrue((boolean)Base64.isArrayByteBase64((byte[])cookie.getValue().getBytes()));
        Assert.assertTrue((boolean)new Date().before(new Date(this.determineExpiryTimeFromBased64EncodedToken(cookie.getValue()))));
    }

    @Test
    public void obtainPasswordReturnsNullForTokenWithNullCredentials() throws Exception {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"username", null);
        Assert.assertNull((Object)this.services.retrievePassword((Authentication)token));
    }

    @Test
    public void negativeValidityPeriodIsSetOnCookieButExpiryTimeRemainsAtTwoWeeks() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("_spring_security_remember_me", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        this.services.setTokenValiditySeconds(-1);
        this.services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"someone", (Object)"password", new String[]{"ROLE_ABC"}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        Assert.assertNotNull((Object)cookie);
        Assert.assertTrue((this.determineExpiryTimeFromBased64EncodedToken(cookie.getValue()) - System.currentTimeMillis() > 1209550L ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)cookie.getMaxAge());
        Assert.assertTrue((boolean)Base64.isArrayByteBase64((byte[])cookie.getValue().getBytes()));
    }
}

