/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.switchuser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.util.FieldUtils;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.switchuser.SwitchUserAuthorityChanger;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.authentication.switchuser.SwitchUserGrantedAuthority;

public class SwitchUserFilterTests {
    private static final List<GrantedAuthority> ROLES_12 = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ONE", "ROLE_TWO"});

    @Before
    public void authenticateCurrentUser() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
    }

    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    private MockHttpServletRequest createMockSwitchRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setRequestURI("/j_spring_security_switch_user");
        return request;
    }

    private Authentication switchToUser(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", name);
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        return filter.attemptSwitchUser((HttpServletRequest)request);
    }

    @Test
    public void requiresExitUserMatchesCorrectly() {
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setExitUserUrl("/j_spring_security_my_exit_user");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_spring_security_my_exit_user");
        Assert.assertTrue((boolean)filter.requiresExitUser((HttpServletRequest)request));
    }

    @Test
    public void requiresSwitchMatchesCorrectly() {
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setSwitchUserUrl("/j_spring_security_my_switch_user");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_spring_security_my_switch_user");
        Assert.assertTrue((boolean)filter.requiresSwitchUser((HttpServletRequest)request));
    }

    @Test(expected=UsernameNotFoundException.class)
    public void attemptSwitchToUnknownUserFails() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "user-that-doesnt-exist");
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.attemptSwitchUser((HttpServletRequest)request);
    }

    @Test(expected=DisabledException.class)
    public void attemptSwitchToUserThatIsDisabledFails() throws Exception {
        this.switchToUser("mcgarrett");
    }

    @Test(expected=AccountExpiredException.class)
    public void attemptSwitchToUserWithAccountExpiredFails() throws Exception {
        this.switchToUser("wofat");
    }

    @Test(expected=CredentialsExpiredException.class)
    public void attemptSwitchToUserWithExpiredCredentialsFails() throws Exception {
        this.switchToUser("steve");
    }

    @Test(expected=UsernameNotFoundException.class)
    public void switchUserWithNullUsernameThrowsException() throws Exception {
        this.switchToUser(null);
    }

    @Test
    public void attemptSwitchUserIsSuccessfulWithValidUser() throws Exception {
        Assert.assertNotNull((Object)this.switchToUser("jacklord"));
    }

    @Test
    public void switchToLockedAccountCausesRedirectToSwitchFailureUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_spring_security_switch_user");
        request.addParameter("j_username", "mcgarrett");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setTargetUrl("/target");
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.afterPropertiesSet();
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertEquals((Object)"Authentication Failed: User is disabled", (Object)response.getErrorMessage());
        request.setContextPath("/mywebapp");
        request.setRequestURI("/mywebapp/j_spring_security_switch_user");
        filter = new SwitchUserFilter();
        filter.setTargetUrl("/target");
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchFailureUrl("/switchfailed");
        filter.afterPropertiesSet();
        response = new MockHttpServletResponse();
        chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertEquals((Object)"/mywebapp/switchfailed", (Object)response.getRedirectedUrl());
        Assert.assertEquals((Object)"/switchfailed", (Object)FieldUtils.getFieldValue((Object)filter, (String)"switchFailureUrl"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void configMissingUserDetailsServiceFails() throws Exception {
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.setTargetUrl("/main.jsp");
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadConfigMissingTargetUrl() throws Exception {
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.afterPropertiesSet();
    }

    @Test
    public void defaultProcessesFilterUrlMatchesUrlWithPathParameter() {
        MockHttpServletRequest request = this.createMockSwitchRequest();
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        request.setRequestURI("/webapp/j_spring_security_switch_user;jsessionid=8JHDUD723J8");
        Assert.assertTrue((boolean)filter.requiresSwitchUser((HttpServletRequest)request));
    }

    @Test
    public void exitUserJackLordToDanoSucceeds() throws Exception {
        UsernamePasswordAuthenticationToken source = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50", ROLES_12);
        ArrayList<Object> adminAuths = new ArrayList<Object>();
        adminAuths.addAll(ROLES_12);
        adminAuths.add(new SwitchUserGrantedAuthority("PREVIOUS_ADMINISTRATOR", (Authentication)source));
        UsernamePasswordAuthenticationToken admin = new UsernamePasswordAuthenticationToken((Object)"jacklord", (Object)"hawaii50", adminAuths);
        SecurityContextHolder.getContext().setAuthentication((Authentication)admin);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setRequestURI("/j_spring_security_exit_user");
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setExitUserUrl("/j_spring_security_exit_user");
        filter.setSuccessHandler((AuthenticationSuccessHandler)new SimpleUrlAuthenticationSuccessHandler("/webapp/someOtherUrl"));
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
        Authentication targetAuth = SecurityContextHolder.getContext().getAuthentication();
        Assert.assertNotNull((Object)targetAuth);
        Assert.assertEquals((Object)"dano", (Object)targetAuth.getPrincipal());
    }

    @Test(expected=AuthenticationException.class)
    public void exitUserWithNoCurrentUserFails() throws Exception {
        SecurityContextHolder.clearContext();
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setRequestURI("/j_spring_security_exit_user");
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setExitUserUrl("/j_spring_security_exit_user");
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void redirectToTargetUrlIsCorrect() throws Exception {
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setContextPath("/webapp");
        request.addParameter("j_username", "jacklord");
        request.setRequestURI("/webapp/j_spring_security_switch_user");
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setSuccessHandler((AuthenticationSuccessHandler)new SimpleUrlAuthenticationSuccessHandler("/someOtherUrl"));
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertEquals((Object)"/webapp/someOtherUrl", (Object)response.getRedirectedUrl());
    }

    @Test
    public void redirectOmitsContextPathIfUseRelativeContextSet() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setContextPath("/webapp");
        request.addParameter("j_username", "jacklord");
        request.setRequestURI("/webapp/j_spring_security_switch_user");
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        SimpleUrlAuthenticationSuccessHandler switchSuccessHandler = new SimpleUrlAuthenticationSuccessHandler("/someOtherUrl");
        DefaultRedirectStrategy contextRelativeRedirector = new DefaultRedirectStrategy();
        contextRelativeRedirector.setContextRelative(true);
        switchSuccessHandler.setRedirectStrategy((RedirectStrategy)contextRelativeRedirector);
        filter.setSuccessHandler((AuthenticationSuccessHandler)switchSuccessHandler);
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertEquals((Object)"/someOtherUrl", (Object)response.getRedirectedUrl());
    }

    @Test
    public void testSwitchRequestFromDanoToJackLord() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/webapp/j_spring_security_switch_user");
        request.addParameter("j_username", "jacklord");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchUserUrl("/j_spring_security_switch_user");
        filter.setSuccessHandler((AuthenticationSuccessHandler)new SimpleUrlAuthenticationSuccessHandler("/webapp/someOtherUrl"));
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)request, (ServletResponse)response);
        Authentication targetAuth = SecurityContextHolder.getContext().getAuthentication();
        Assert.assertNotNull((Object)targetAuth);
        Assert.assertTrue((boolean)(targetAuth.getPrincipal() instanceof UserDetails));
        Assert.assertEquals((Object)"jacklord", (Object)((User)targetAuth.getPrincipal()).getUsername());
    }

    @Test
    public void modificationOfAuthoritiesWorks() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "jacklord");
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService((UserDetailsService)new MockUserDetailsService());
        filter.setSwitchUserAuthorityChanger(new SwitchUserAuthorityChanger(){

            public Collection<GrantedAuthority> modifyGrantedAuthorities(UserDetails targetUser, Authentication currentAuthentication, Collection<GrantedAuthority> authoritiesToBeGranted) {
                ArrayList<GrantedAuthority> auths = new ArrayList<GrantedAuthority>();
                auths.add((GrantedAuthority)new GrantedAuthorityImpl("ROLE_NEW"));
                return auths;
            }
        });
        Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)result.getAuthorities().size());
        Assert.assertTrue((boolean)AuthorityUtils.authorityListToSet((Collection)result.getAuthorities()).contains("ROLE_NEW"));
    }

    private class MockUserDetailsService
    implements UserDetailsService {
        private String password = "hawaii50";

        private MockUserDetailsService() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            if ("jacklord".equals(username) || "dano".equals(username)) {
                return new User(username, this.password, true, true, true, true, (Collection)ROLES_12);
            }
            if ("mcgarrett".equals(username)) {
                return new User(username, this.password, false, true, true, true, (Collection)ROLES_12);
            }
            if ("wofat".equals(username)) {
                return new User(username, this.password, true, false, true, true, (Collection)ROLES_12);
            }
            if ("steve".equals(username)) {
                return new User(username, this.password, true, true, false, true, (Collection)ROLES_12);
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }
}

