/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

public class BasicAuthenticationEntryPointTests
extends TestCase {
    public BasicAuthenticationEntryPointTests() {
    }

    public BasicAuthenticationEntryPointTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(BasicAuthenticationEntryPointTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingRealmName() throws Exception {
        BasicAuthenticationEntryPoint ep = new BasicAuthenticationEntryPoint();
        try {
            ep.afterPropertiesSet();
            BasicAuthenticationEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAuthenticationEntryPointTests.assertEquals((String)"realmName must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        BasicAuthenticationEntryPoint ep = new BasicAuthenticationEntryPoint();
        ep.setRealmName("realm");
        BasicAuthenticationEntryPointTests.assertEquals((String)"realm", (String)ep.getRealmName());
    }

    public void testNormalOperation() throws Exception {
        BasicAuthenticationEntryPoint ep = new BasicAuthenticationEntryPoint();
        ep.setRealmName("hello");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String msg = "These are the jokes kid";
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, (AuthenticationException)new DisabledException(msg));
        BasicAuthenticationEntryPointTests.assertEquals((int)401, (int)response.getStatus());
        BasicAuthenticationEntryPointTests.assertEquals((String)msg, (String)response.getErrorMessage());
        BasicAuthenticationEntryPointTests.assertEquals((Object)"Basic realm=\"hello\"", (Object)response.getHeader("WWW-Authenticate"));
    }
}

